/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.service.Service;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;

@Singleton
public class LogServiceOld
implements Service<LogServiceOld> {
    private String dir;
    private String logEntry = "";

    @Override
    public String getName() {
        return "Logging";
    }

    @Override
    public void init() {
        System.out.println(this.info("---- Logging Service"));
        Path path = Paths.get("logs", new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
        try {
            String jarPath = SpaceSDK.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File file = new File(jarPath);
            this.dir = file.getParent();
        }
        catch (URISyntaxException e) {
            this.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    @Override
    public void register(LogServiceOld obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return this;
    }

    public String fatal(String message) {
        return "[FATAL] " + message;
    }

    public String error(String message) {
        return "[ERROR] " + message;
    }

    public String warning(String message) {
        return "[WARNING] " + message;
    }

    public String info(String message) {
        return "[INFO] " + message;
    }

    public String debug(String message) {
        return "[DEBUG] " + message;
    }

    public void save() {
        try {
            String logFileName;
            File logFile;
            if (this.deleteOldLogs(30)) {
                this.info("Oldest log file has been discarded.");
            }
            if ((logFile = new File(logFileName = this.dir + "/logs/AS-RAC-Space-SDK-Log." + DateTime.now().toString("yyyyMMdd.hhmmssSSSZZ") + ".txt")).getParentFile().mkdirs()) {
                this.info("The parent file directories did not exist for the log file. Created now!");
            }
            if (!logFile.createNewFile()) {
                this.error("File failed to be created. Please ensure " + this.dir + "/logs/ has the correct environment settings. Skipping save...");
                return;
            }
            String tempLogEntry = this.logEntry;
            FileOutputStream fos = new FileOutputStream(logFileName);
            byte[] compressedLog = this.compress(tempLogEntry);
            fos.write(compressedLog);
            this.logEntry = this.logEntry.replace(tempLogEntry, "");
            fos.close();
        }
        catch (IOException e) {
            this.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    private boolean deleteOldLogs(int filesToKeep) {
        File[] logs = new File(this.dir + "/logs/").listFiles();
        File toBeDeleted = null;
        long maxOld = Long.MAX_VALUE;
        if (logs != null && logs.length > filesToKeep - 1) {
            for (File f : logs) {
                if (f.lastModified() >= maxOld) continue;
                maxOld = f.lastModified();
                toBeDeleted = f;
            }
            if (toBeDeleted != null) {
                return toBeDeleted.delete();
            }
        }
        return false;
    }

    private byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream out = new DeflaterOutputStream(baos);
            ((OutputStream)out).write(text.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return baos.toByteArray();
    }

    private String decompress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InflaterOutputStream out = new InflaterOutputStream(baos);
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).close();
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

