/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Singleton
public class ConfigService
implements Service<ConfigService> {
    private String propPath;
    JsonObject config = new JsonObject();
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    @Override
    public void init() {
        System.out.println(this.ls.info("---- Config Service"));
        try {
            String propPath;
            String jarPath = SpaceSDK.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File file = new File(jarPath);
            String dir = file.getParent();
            this.propPath = propPath = dir + "/config.json";
            File prop = new File(propPath);
            if (!prop.exists()) {
                System.out.println(this.ls.info("No config file found... generating..."));
                if (prop.createNewFile()) {
                    System.out.println(this.ls.info("Writing defaults to config..."));
                    BufferedWriter writer = new BufferedWriter(new FileWriter(prop));
                    writer.write(this.config.toString());
                    writer.close();
                }
            } else {
                this.load();
            }
        }
        catch (URISyntaxException e) {
            this.ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
        catch (IOException e) {
            this.ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            File prop = new File(this.propPath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(prop));
            writer.write(this.config.toString());
            writer.close();
        }
        catch (IOException e) {
            this.ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            File prop = new File(this.propPath);
            String content = new String(Files.readAllBytes(prop.toPath()));
            this.config = JsonParser.parseString((String)content).getAsJsonObject();
        }
        catch (IOException e) {
            this.ls.fatal(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    public String getValue(String key) {
        if (this.config.has(key)) {
            return this.config.get(key).getAsString();
        }
        return null;
    }

    public String getValue(String key, String defaultValue) {
        if (this.config.has(key)) {
            return this.config.get(key).getAsString();
        }
        this.setup(key, defaultValue);
        this.save();
        return defaultValue;
    }

    public JsonElement getJsonValue(String key) {
        if (this.config.has(key)) {
            return this.config.get(key);
        }
        return null;
    }

    public ConfigService set(String key, String element) {
        this.config.addProperty(key, element);
        return this;
    }

    public ConfigService set(String key, JsonElement element) {
        this.config.add(key, element);
        return this;
    }

    public ConfigService setup(String key) {
        if (!this.config.has(key)) {
            this.config.addProperty(key, "");
        }
        return this;
    }

    public ConfigService setup(String key, String def) {
        if (!this.config.has(key)) {
            this.config.addProperty(key, def);
        }
        return this;
    }

    @Override
    public String getName() {
        return "Config";
    }

    @Override
    public void register(ConfigService obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return this.ls;
    }
}

