/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.task;

import java.util.UUID;

public abstract class NebulaTask {
    protected String friendlyName = null;
    protected UUID uuid;
    protected Long lastRun = 0L;
    protected Long nextRun = 0L;
    protected boolean isCanceled = false;
    protected boolean isAsync = false;
    protected Runnable then;

    public NebulaTask(String name, boolean isAsync) {
        this.friendlyName = name;
        this.uuid = UUID.randomUUID();
        this.isAsync = isAsync;
    }

    public NebulaTask() {
    }

    public boolean isReady() {
        return System.currentTimeMillis() >= this.nextRun && !this.isCanceled;
    }

    public void tick() {
        this.lastRun = System.currentTimeMillis();
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean async) {
        this.isAsync = async;
    }

    public abstract void run();

    public void cancel() {
        this.isCanceled = true;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Long getLastRun() {
        return this.lastRun;
    }

    public Long getNextRun() {
        return this.nextRun;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Runnable getThen() {
        return this.then;
    }

    public NebulaTask then(Runnable runnable) {
        this.then = runnable;
        return this;
    }

    public void setThen(Runnable then) {
        this.then = then;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    public void setNextRun(Long nextRun) {
        this.nextRun = nextRun;
    }

    public void setLastRun(Long lastRun) {
        this.lastRun = lastRun;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }
}

