/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.strut;

import com.snaju.nebula.entities.strut.ByteOrder;
import com.snaju.nebula.entities.strut.CheckSum;
import com.snaju.nebula.entities.strut.Strut;
import com.snaju.nebula.entities.strut.StrutElement;
import com.snaju.nebula.utils.CRC16;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public abstract class StrutInterface<T> {
    ByteBuffer buffer;
    protected int size = 0;
    private java.nio.ByteOrder byteOrder;
    private CheckSum checkSum = CheckSum.NONE;
    private Strut strut;
    public static ByteOrder byteOrderOverride = ByteOrder.INHERIT;

    public int getSize() {
        return this.size;
    }

    private int getSizeOfNativeField(Class type) {
        if (type == Short.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE) {
            return 4;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        if (type == Byte.TYPE) {
            return 1;
        }
        if (type == Long.TYPE) {
            return 8;
        }
        return 0;
    }

    private Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        return a.intValue() + b.intValue();
    }

    private Number multiplyNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() * b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() * b.longValue();
        }
        return a.intValue() * b.intValue();
    }

    public Class getBaseTypeOfArray(Class type) {
        if (type.isArray()) {
            Class<?> subtype = type.getComponentType();
            return this.getBaseTypeOfArray(subtype);
        }
        return type;
    }

    public T init() throws Exception {
        this.calcSize();
        this.buildBuffer();
        return (T)this;
    }

    public void calcSize() throws Exception {
        if (this.getClass().getAnnotation(Strut.class) != null) {
            this.strut = this.getClass().getAnnotation(Strut.class);
            this.byteOrder = this.strut.byteOrder().getBufferOrder();
            if (this.strut.size() > 0) {
                this.size = this.strut.size();
            } else {
                for (Field f : this.getClass().getFields()) {
                    if (f.getAnnotation(StrutElement.class) == null) continue;
                    f.setAccessible(true);
                    StrutElement elm = f.getAnnotation(StrutElement.class);
                    if (List.class.isAssignableFrom(f.getType())) {
                        if (elm.basedOnField().equalsIgnoreCase("") || elm.listOf() == Void.class) continue;
                        int sizeOfElm = this.getSizeOfNativeField(elm.listOf());
                        if (StrutInterface.class.isAssignableFrom(elm.listOf())) {
                            StrutInterface in = (StrutInterface)elm.listOf().newInstance();
                            in.calcSize();
                            sizeOfElm = in.getSize();
                        }
                        Field linkField = this.getClass().getField(elm.basedOnField());
                        this.size = this.addNumbers(this.size, this.multiplyNumbers((Number)linkField.get(this), sizeOfElm)).intValue();
                        continue;
                    }
                    if (f.getType().isArray()) {
                        Class typeOfArray = this.getBaseTypeOfArray(f.getType());
                        this.size += elm.size() * this.getSizeOfNativeField(typeOfArray);
                        continue;
                    }
                    if (f.getType().isPrimitive()) {
                        this.size += this.getSizeOfNativeField(f.getType());
                        continue;
                    }
                    if (StrutInterface.class.isAssignableFrom(f.getType())) {
                        if (f.get(this) == null) {
                            f.set(this, f.getType().newInstance());
                        }
                        if (f.get(this) != null) {
                            this.size += ((StrutInterface)f.get(this)).getSize();
                            continue;
                        }
                        throw new Exception("Sub Strut is set to null (" + f.getName() + ")");
                    }
                    throw new Exception("Invalid Type of Field (" + f.getType().getSimpleName() + ")");
                }
                if (this.strut.hasChecksum()) {
                    this.size += this.getSizeOfNativeField(this.checksumType());
                }
            }
        } else {
            throw new Exception("A strut interface must be annotated with @Strut");
        }
    }

    public List<Field> getDataFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : this.getClass().getFields()) {
            if (f.getAnnotation(StrutElement.class) == null) continue;
            f.setAccessible(true);
            StrutElement elm = f.getAnnotation(StrutElement.class);
            fields.add(f);
        }
        return fields;
    }

    private ByteBuffer grow(ByteBuffer buffer, int add) {
        ByteBuffer newBuff = ByteBuffer.allocate(buffer.capacity() + add);
        for (byte b : buffer.array()) {
            newBuff.put(b);
        }
        return newBuff;
    }

    private ByteBuffer addToBuffer(ByteBuffer buffer, Object obj) {
        if (obj == null) {
            return buffer;
        }
        if (buffer.capacity() < this.getSizeOfNativeField(obj.getClass())) {
            int diff = this.getSizeOfNativeField(obj.getClass()) + buffer.capacity() - buffer.capacity();
            buffer = this.grow(buffer, Math.abs(diff));
        }
        if (obj instanceof Short) {
            buffer.putShort((Short)obj);
        } else if (obj instanceof Integer) {
            buffer.putInt((Integer)obj);
        } else if (obj instanceof Float) {
            buffer.putFloat(((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            buffer.put((Byte)obj);
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(obj, i);
                this.addToBuffer(buffer, arrayElement);
            }
        }
        return buffer;
    }

    private Object[] expandArray(Object[] orgin) {
        Object[] newArray = new Object[orgin.length + 1];
        System.arraycopy(orgin, 0, newArray, 0, orgin.length);
        return newArray;
    }

    public Object getFromBuffer(ByteBuffer buffer, Class type, Object obj, StrutElement element) throws IllegalAccessException {
        if (type == Short.class || type == Short.TYPE) {
            return buffer.getShort();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return buffer.getInt();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(buffer.getFloat());
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return buffer.get();
        }
        if (type == Long.class || type == Long.TYPE) {
            return buffer.getLong();
        }
        if (List.class.isAssignableFrom(type)) {
            try {
                Class c = element.listOf();
                ArrayList<Object> list = new ArrayList<Object>();
                Field f = this.getClass().getField(element.basedOnField());
                Number size = (Number)f.get(this);
                for (int i = 0; i < size.intValue(); ++i) {
                    list.add(this.getFromBuffer(buffer, c, new Object[element.listOfArraySize()], element));
                }
                return list;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        } else if (type.isArray()) {
            int sizeOfArray = ArrayUtils.getLength((Object)obj);
            for (int i = 0; i < sizeOfArray; ++i) {
                Array.set(obj, i, this.getFromBuffer(buffer, this.getBaseTypeOfArray(type), Array.get(obj, i), element));
            }
            return obj;
        }
        return null;
    }

    public T resetBuffer() {
        this.buffer = null;
        this.buffer = ByteBuffer.allocate(this.getSize());
        return (T)this;
    }

    public T buildBuffer() throws IllegalAccessException {
        return this.buildBuffer(null);
    }

    public T buildBuffer(ByteBuffer buffer) throws IllegalAccessException {
        boolean orgin = false;
        if (buffer == null) {
            buffer = ByteBuffer.allocate(this.getSize());
            orgin = true;
        }
        if (this.strut != null && this.strut.fillWith() != 0) {
            int pos = buffer.position();
            for (int i = 0; i < this.getSize(); ++i) {
                buffer.put(this.strut.fillWith());
            }
            buffer.position(pos);
        }
        if (this.strut == null) {
            try {
                this.calcSize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Field f : this.getClass().getFields()) {
            if (f.getAnnotation(StrutElement.class) == null) continue;
            StrutElement element = f.getAnnotation(StrutElement.class);
            f.setAccessible(true);
            if (StrutInterface.class.isAssignableFrom(f.getType())) {
                if (element.byteOrder() != ByteOrder.INHERIT) {
                    byteOrderOverride = element.byteOrder();
                }
                ((StrutInterface)f.get(this)).buildBuffer(buffer);
                continue;
            }
            if (element.byteOrder() == ByteOrder.INHERIT) {
                if (byteOrderOverride != ByteOrder.INHERIT) {
                    buffer.order(byteOrderOverride.getBufferOrder());
                } else {
                    buffer.order(this.strut.byteOrder().getBufferOrder());
                }
            } else {
                buffer.order(element.byteOrder().getBufferOrder());
            }
            if (List.class.isAssignableFrom(f.getType())) {
                for (Object o : (List)f.get(this)) {
                    if (StrutInterface.class.isAssignableFrom(o.getClass())) {
                        if (element.byteOrder() != ByteOrder.INHERIT) {
                            byteOrderOverride = element.byteOrder();
                        }
                        ((StrutInterface)o).buildBuffer(buffer);
                        continue;
                    }
                    buffer = this.addToBuffer(buffer, o);
                }
                continue;
            }
            buffer = this.addToBuffer(buffer, f.get(this));
        }
        this.buffer = buffer;
        if (orgin && this.strut.hasChecksum()) {
            int sizeOfChecksum = this.getSizeOfNativeField(this.checksumType());
            this.buffer.position(buffer.capacity() - sizeOfChecksum);
            this.buffer.order(this.strut.checkSumOrder().getBufferOrder());
            Object cc = this.calcChecksum();
            this.buffer = this.addToBuffer(buffer, cc);
        }
        return (T)this;
    }

    public byte[] getArray() {
        return this.buffer.array();
    }

    public static <T extends StrutInterface> T fromArray(T obj, byte[] bytes) {
        try {
            obj.calcSize();
            obj.readIn(ByteBuffer.wrap(bytes));
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ByteBuffer readIn(ByteBuffer buffer) throws Exception {
        Strut strut = this.getClass().getAnnotation(Strut.class);
        if (this.buffer == null) {
            this.buffer = buffer;
        }
        for (Field f : this.getClass().getFields()) {
            if (f.getAnnotation(StrutElement.class) == null) continue;
            StrutElement element = f.getAnnotation(StrutElement.class);
            if (element.byteOrder() != ByteOrder.INHERIT) {
                buffer.order(element.byteOrder().getBufferOrder());
            } else {
                buffer.order(strut.byteOrder().getBufferOrder());
            }
            f.setAccessible(true);
            if (StrutInterface.class.isAssignableFrom(f.getType())) {
                buffer = ((StrutInterface)f.get(this)).readIn(buffer);
                continue;
            }
            f.set(this, this.getFromBuffer(buffer, f.getType(), f.get(this), element));
        }
        return buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Class checksumType() {
        return Short.TYPE;
    }

    public Object calcChecksum() {
        byte[] data = this.getArray();
        byte[] b = Arrays.copyOfRange(data, 16, data.length - 2);
        CRC16 crc16 = new CRC16(b);
        return crc16.getValue();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("__ [").append(this.getClass().getSimpleName()).append("] __").append("\n");
        try {
            for (Field f : this.getClass().getFields()) {
                if (f.getAnnotation(StrutElement.class) == null) continue;
                StrutElement element = f.getAnnotation(StrutElement.class);
                f.setAccessible(true);
                if (StrutInterface.class.isAssignableFrom(f.getType())) {
                    builder.append(f.get(this).toString());
                    continue;
                }
                if (f.get(this) != null) {
                    builder.append(f.getName()).append(": ").append(f.get(this).toString()).append("\n");
                    continue;
                }
                builder.append(f.getName()).append(": ").append(" NULL FIELD").append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        builder.append("__END__\n");
        return builder.toString();
    }
}

