/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.socket.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class NebulaUDPSender {
    private final DatagramSocket socket = new DatagramSocket();

    public NebulaUDPSender() throws IOException {
        this.socket.setReuseAddress(true);
    }

    public void send(byte[] data, String host, int port) throws IOException {
        InetAddress address = InetAddress.getByName(host);
        DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
        this.socket.send(packet);
    }

    public void send(String message, String host, int port) throws IOException {
        this.send(message.getBytes("UTF-8"), host, port);
    }

    public void close() {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }
}

