/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.socket.tcp;

import com.snaju.nebula.entities.socket.tcp.NebulaSocketClient;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NebulaSocketServer<T extends NebulaSocketClient> {
    private int port;
    private ServerSocket server;
    private ConcurrentHashMap<UUID, T> clients = new ConcurrentHashMap();
    private Class<T> clientClass;

    public NebulaSocketServer(int port, Class<T> tClass) throws IOException {
        this.port = port;
        this.server = new ServerSocket(this.port);
        this.clientClass = tClass;
    }

    public abstract void onAccept(T var1);

    private void accept() {
        try {
            Socket socket = this.server.accept();
            socket.setKeepAlive(true);
            socket.setSoTimeout(60000);
            NebulaSocketClient client = (NebulaSocketClient)this.clientClass.newInstance();
            client.setSocket(socket);
            Thread thread = new Thread(client);
            client.setRunner(thread);
            this.clients.put(client.getUuid(), client);
            this.onAccept(client);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.accept();
    }
}

