/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.socket.tcp;

import com.snaju.nebula.entities.socket.tcp.NebulaSocketClient;
import java.io.IOException;
import java.net.Socket;

public abstract class NebulaSocketConnector<T extends NebulaSocketClient> {
    private final String host;
    private final int port;
    private final Class<T> clientClass;
    private T client;

    public NebulaSocketConnector(String host, int port, Class<T> clientClass) {
        this.host = host;
        this.port = port;
        this.clientClass = clientClass;
    }

    public void connect() throws IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setKeepAlive(true);
        socket.setSoTimeout(60000);
        try {
            NebulaSocketClient instance = (NebulaSocketClient)this.clientClass.newInstance();
            instance.setSocket(socket);
            Thread runner = new Thread(instance);
            instance.setRunner(runner);
            this.client = instance;
            this.onConnect(this.client);
            runner.start();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate client class", e);
        }
    }

    protected abstract void onConnect(T var1);

    public T getClient() {
        return this.client;
    }
}

