/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.entities.plugin;

import com.google.common.reflect.ClassPath;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.PluginManager;
import com.snaju.nebula.injection.InjectionRoot;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;

public abstract class SpacePlugin
implements InjectionRoot {
    private File file;
    private String hash;
    private double version;
    private boolean autoUpdate;

    public abstract void onEnable();

    public abstract void onDisable();

    public Collection<Module> getModules() {
        return Collections.singletonList(new AbstractModule(){

            protected void configure() {
                try {
                    ClassLoader loader = SpacePlugin.this.getClass().getClassLoader();
                    String basePackage = SpacePlugin.this.getClass().getPackage().getName();
                    ClassPath classPath = ClassPath.from((ClassLoader)loader);
                    for (ClassPath.ClassInfo info : classPath.getTopLevelClassesRecursive(basePackage)) {
                        try {
                            Class clazz = info.load();
                            if (clazz.isInterface() || clazz.isEnum() || Modifier.isAbstract(clazz.getModifiers()) || clazz == SpacePlugin.this.getClass()) continue;
                            boolean isSingleton = clazz.isAnnotationPresent(javax.inject.Singleton.class) || clazz.isAnnotationPresent(Singleton.class);
                            boolean hasInjectConstructor = false;
                            for (Constructor<?> c : clazz.getDeclaredConstructors()) {
                                if (!c.isAnnotationPresent(javax.inject.Inject.class) && !c.isAnnotationPresent(Inject.class)) continue;
                                hasInjectConstructor = true;
                                break;
                            }
                            if (!isSingleton && !hasInjectConstructor) continue;
                            this.bind(clazz).in(Scopes.SINGLETON);
                        }
                        catch (Exception | NoClassDefFoundError throwable) {}
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onLoad() {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public SpaceSDK core() {
        return SpaceSDK.getInstance();
    }

    public PluginManager pluginManager() {
        return SpaceSDK.getInstance().getPluginManager();
    }
}

