/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.utils;

import java.util.Arrays;

public class ByteArrayUtils {
    public static final byte[] EMPTY = new byte[0];

    public static byte[] plusOne(byte[] a) {
        int i;
        byte[] b = Arrays.copyOf(a, a.length);
        for (i = b.length - 1; i >= 0 && b[i] == -1; --i) {
            b[i] = 0;
        }
        if (i == -1) {
            throw new IllegalArgumentException("overflow");
        }
        b[i] = (byte)(1 + (b[i] & 0xFF));
        return b;
    }

    public static byte[] minusOne(byte[] a) {
        int i;
        byte[] b = Arrays.copyOf(a, a.length);
        for (i = b.length - 1; i >= 0 && b[i] == 0; --i) {
            b[i] = -1;
        }
        if (i == -1) {
            throw new IllegalArgumentException("underflow");
        }
        b[i] = (byte)((b[i] & 0xFF) - 1);
        return b;
    }

    public static int compare(byte[] a1, byte[] a2) {
        for (int i = 0; i < a1.length && i < a2.length; ++i) {
            int d = (a1[i] & 0xFF) - (a2[i] & 0xFF);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public static byte[] encodeLong(long x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 56);
        a[offset + 1] = (byte)(x >> 48);
        a[offset + 2] = (byte)(x >> 40);
        a[offset + 3] = (byte)(x >> 32);
        a[offset + 4] = (byte)(x >> 24);
        a[offset + 5] = (byte)(x >> 16);
        a[offset + 6] = (byte)(x >> 8);
        a[offset + 7] = (byte)x;
        return a;
    }

    public static byte[] encodeLongLE(long x, byte[] a, int offset) {
        a[offset] = (byte)x;
        a[offset + 1] = (byte)(x >> 8);
        a[offset + 2] = (byte)(x >> 16);
        a[offset + 3] = (byte)(x >> 24);
        a[offset + 4] = (byte)(x >> 32);
        a[offset + 5] = (byte)(x >> 40);
        a[offset + 6] = (byte)(x >> 48);
        a[offset + 7] = (byte)(x >> 56);
        return a;
    }

    public static byte[] encodeLong(long x) {
        byte[] toReturn = new byte[8];
        return ByteArrayUtils.encodeLong(x, toReturn, 0);
    }

    public static byte[] encodeLongLE(long x) {
        byte[] toReturn = new byte[8];
        return ByteArrayUtils.encodeLongLE(x, toReturn, 0);
    }

    public static long decodeLong(byte[] a, int offset) {
        return (((long)a[offset] & 0xFFL) << 56) + (((long)a[offset + 1] & 0xFFL) << 48) + (((long)a[offset + 2] & 0xFFL) << 40) + (((long)a[offset + 3] & 0xFFL) << 32) + (((long)a[offset + 4] & 0xFFL) << 24) + (((long)a[offset + 5] & 0xFFL) << 16) + (((long)a[offset + 6] & 0xFFL) << 8) + ((long)a[offset + 7] & 0xFFL);
    }

    public static long decodeLongLE(byte[] a, int offset) {
        return ((long)a[offset] & 0xFFL) + (((long)a[offset + 1] & 0xFFL) << 8) + (((long)a[offset + 2] & 0xFFL) << 16) + (((long)a[offset + 3] & 0xFFL) << 24) + (((long)a[offset + 4] & 0xFFL) << 32) + (((long)a[offset + 5] & 0xFFL) << 40) + (((long)a[offset + 6] & 0xFFL) << 48) + (((long)a[offset + 7] & 0xFFL) << 56);
    }

    public static long decodeUnsigned7Bytes(byte[] a, int offset) {
        return (((long)a[offset] & 0xFFL) << 48) + (((long)a[offset + 1] & 0xFFL) << 40) + (((long)a[offset + 2] & 0xFFL) << 32) + (((long)a[offset + 3] & 0xFFL) << 24) + (((long)a[offset + 4] & 0xFFL) << 16) + (((long)a[offset + 5] & 0xFFL) << 8) + ((long)a[offset + 6] & 0xFFL);
    }

    public static byte[] encodeUnsigned6Bytes(long x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 40);
        a[offset + 1] = (byte)(x >> 32);
        a[offset + 2] = (byte)(x >> 24);
        a[offset + 3] = (byte)(x >> 16);
        a[offset + 4] = (byte)(x >> 8);
        a[offset + 5] = (byte)x;
        return a;
    }

    public static long decodeUnsigned6Bytes(byte[] a, int offset) {
        return (((long)a[offset] & 0xFFL) << 40) + (((long)a[offset + 1] & 0xFFL) << 32) + (((long)a[offset + 2] & 0xFFL) << 24) + (((long)a[offset + 3] & 0xFFL) << 16) + (((long)a[offset + 4] & 0xFFL) << 8) + ((long)a[offset + 5] & 0xFFL);
    }

    public static long decode6Bytes(byte[] a, int offset) {
        long x = ByteArrayUtils.decodeUnsigned6Bytes(a, offset);
        if (a[offset] < 0) {
            return x - 0x1000000000000L;
        }
        return x;
    }

    public static long decode5Bytes(byte[] a, int offset) {
        long x = ByteArrayUtils.decodeUnsigned5Bytes(a, offset);
        if (a[offset] < 0) {
            return x - 0x10000000000L;
        }
        return x;
    }

    public static byte[] encodeUnsigned5Bytes(long x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 32);
        a[offset + 1] = (byte)(x >> 24);
        a[offset + 2] = (byte)(x >> 16);
        a[offset + 3] = (byte)(x >> 8);
        a[offset + 4] = (byte)x;
        return a;
    }

    public static long decodeUnsigned5Bytes(byte[] a, int offset) {
        return (((long)a[offset] & 0xFFL) << 32) + (((long)a[offset + 1] & 0xFFL) << 24) + (((long)a[offset + 2] & 0xFFL) << 16) + (((long)a[offset + 3] & 0xFFL) << 8) + ((long)a[offset + 4] & 0xFFL);
    }

    public static byte[] encodeInt(int x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 24);
        a[offset + 1] = (byte)(x >> 16);
        a[offset + 2] = (byte)(x >> 8);
        a[offset + 3] = (byte)x;
        return a;
    }

    public static byte[] encodeIntLE(int x, byte[] a, int offset) {
        a[offset + 3] = (byte)(x >> 24);
        a[offset + 2] = (byte)(x >> 16);
        a[offset + 1] = (byte)(x >> 8);
        a[offset] = (byte)x;
        return a;
    }

    public static byte[] encodeUnsignedIntLE(long x, byte[] a, int offset) {
        a[offset + 3] = (byte)(x >> 24);
        a[offset + 2] = (byte)(x >> 16);
        a[offset + 1] = (byte)(x >> 8);
        a[offset] = (byte)x;
        return a;
    }

    public static byte[] encodeInt(int x) {
        byte[] toReturn = new byte[4];
        return ByteArrayUtils.encodeInt(x, toReturn, 0);
    }

    public static byte[] encodeIntLE(int x) {
        byte[] toReturn = new byte[4];
        return ByteArrayUtils.encodeIntLE(x, toReturn, 0);
    }

    public static int decodeInt(byte[] a, int offset) {
        return ((a[offset] & 0xFF) << 24) + ((a[offset + 1] & 0xFF) << 16) + ((a[offset + 2] & 0xFF) << 8) + (a[offset + 3] & 0xFF);
    }

    public static int decodeIntLE(byte[] a, int offset) {
        return ((a[offset + 3] & 0xFF) << 24) + ((a[offset + 2] & 0xFF) << 16) + ((a[offset + 1] & 0xFF) << 8) + (a[offset] & 0xFF);
    }

    public static long decodeUnsignedIntLE(byte[] a, int offset) {
        return ((long)(a[offset + 3] & 0xFF) << 24) + (long)((a[offset + 2] & 0xFF) << 16) + (long)((a[offset + 1] & 0xFF) << 8) + (long)(a[offset] & 0xFF);
    }

    public static byte[] encodeUnsigned3Bytes(int x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 16);
        a[offset + 1] = (byte)(x >> 8);
        a[offset + 2] = (byte)x;
        return a;
    }

    public static int decodeUnsigned3Bytes(byte[] a, int offset) {
        return ((a[offset] & 0xFF) << 16) + ((a[offset + 1] & 0xFF) << 8) + (a[offset + 2] & 0xFF);
    }

    public static int decodeUnsigned3BytesLE(byte[] a, int offset) {
        return ((a[offset + 2] & 0xFF) << 16) + ((a[offset + 1] & 0xFF) << 8) + (a[offset] & 0xFF);
    }

    public static byte[] encodeUnsignedShort(int x, byte[] a, int offset) {
        a[offset] = (byte)(x >> 8);
        a[offset + 1] = (byte)x;
        return a;
    }

    public static byte[] encodeUnsignedShort(int x) {
        byte[] toReturn = new byte[2];
        return ByteArrayUtils.encodeUnsignedShort(x, toReturn, 0);
    }

    public static byte[] encodeUnsignedShortLE(int x, byte[] a, int offset) {
        a[offset + 1] = (byte)(x >> 8);
        a[offset] = (byte)x;
        return a;
    }

    public static byte[] encodeUnsignedShortLE(int x) {
        byte[] toReturn = new byte[2];
        return ByteArrayUtils.encodeUnsignedShortLE(x, toReturn, 0);
    }

    public static short decodeShort(byte[] a, int offset) {
        int x = ((a[offset] & 0xFF) << 8) + (a[offset + 1] & 0xFF);
        return (short)x;
    }

    public static short decodeShortLE(byte[] a, int offset) {
        int x = ((a[offset + 1] & 0xFF) << 8) + (a[offset] & 0xFF);
        return (short)x;
    }

    public static int decodeUnsignedShort(byte[] a, int offset) {
        int x = ((a[offset] & 0xFF) << 8) + (a[offset + 1] & 0xFF);
        return x;
    }

    public static int decodeUnsignedShortLE(byte[] a, int offset) {
        return ((a[offset + 1] & 0xFF) << 8) + (a[offset] & 0xFF);
    }

    public static byte[] encodeUnsignedByte(short x, byte[] a, int offset) {
        return ByteArrayUtils.encodeByte(x, a, offset);
    }

    public static byte[] encodeByte(short x, byte[] a, int offset) {
        a[offset] = (byte)x;
        return a;
    }

    public static short decodeUnsignedByte(byte[] a, int offset) {
        return (short)(a[offset] & 0xFF);
    }

    public static byte decodeByte(byte[] a, int offset) {
        return a[offset];
    }
}

