/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.mcs.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.snaju.nebula.entities.comm.CommAdapter;
import com.snaju.nebula.service.CommService;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import com.spacenetwork.mcs.entites.comm.obj.PayloadPair;
import com.spacenetwork.mcs.entites.comm.obj.SNPacket;
import fr.devnied.bitlib.BytesUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Singleton;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

@Singleton
public class SNCommService
implements Service<SNCommService> {
    private HashMap<Integer, PayloadPair> payloads = new HashMap();
    public static HashMap<Integer, Integer> idMaps = new HashMap();

    public String getName() {
        return "SNCommService";
    }

    public ArrayList<PayloadPair> getKeys() {
        return new ArrayList<PayloadPair>(this.payloads.values());
    }

    public void loadKeys() {
        this.payloads.clear();
        System.out.println("Pulling Keys...");
        JsonObject object = JsonParser.parseString((String)((String)Unirest.get((String)"https://mcs.sn/api/satellites").asString().getBody())).getAsJsonObject();
        if (object.has("success") && object.get("success").getAsBoolean()) {
            int sizeInJson = object.get("data").getAsJsonArray().size();
            System.out.println("Found " + sizeInJson);
            for (JsonElement e : object.get("data").getAsJsonArray()) {
                JsonObject sat = e.getAsJsonObject();
                if (!sat.has("id")) continue;
                System.out.println("Loading SAT #" + sat.get("id").getAsInt());
                int id = sat.get("id").getAsInt();
                byte[] rx = Base64.getDecoder().decode(sat.get("rx").getAsString());
                byte[] tx = Base64.getDecoder().decode(sat.get("tx").getAsString());
                byte[] uhf = Base64.getDecoder().decode(sat.get("uhf").getAsString());
                byte[] iv = Base64.getDecoder().decode(sat.get("iv").getAsString());
                PayloadPair payloadPair = new PayloadPair(rx, tx, uhf, iv);
                this.payloads.put(id, payloadPair);
                System.out.println("Finished " + this.payloads.size() + " / " + sizeInJson);
            }
            System.out.println("Finished loading " + this.payloads.size() + " / " + sizeInJson);
        }
    }

    public Collection<PayloadPair> getPairs() {
        return this.payloads.values();
    }

    public PayloadPair getSatPair(int id) {
        return this.payloads.get(id);
    }

    public void routeOut(byte[] data, int target) {
        for (CommAdapter adapter : CommService.getAdapters().values()) {
            SNPacket packet = new SNPacket(target, data);
            adapter.write((Object)packet);
        }
    }

    public void routeIn(byte[] data) {
        System.out.println("ROUTE-IN: " + BytesUtils.bytesToString((byte[])data));
        try {
            HttpResponse r = Unirest.post((String)"https://mcs.sn/api/telemetry").body(Base64.getEncoder().encode(data)).asString();
            System.out.println((String)r.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void register(SNCommService obj) {
    }

    public LogServiceOld getLogger() {
        return null;
    }
}

