/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.mcs.services;

import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import javax.inject.Singleton;

@Singleton
public class RedisService
implements Service<RedisService> {
    private RedisClient redisClient;
    private StatefulRedisPubSubConnection<String, String> SubConnection;
    private StatefulRedisPubSubConnection<String, String> PubConnection;
    private StatefulRedisConnection<String, String> redisConnection;
    private RedisURI connectUri;

    public void connect() {
        try {
            String redisIp = "stage.mcs.sn";
            int redisPort = 6379;
            System.out.println("Connection on " + redisIp + ":" + redisPort);
            RedisURI.Builder builder = RedisURI.Builder.redis((String)redisIp, (int)redisPort);
            this.connectUri = builder.build();
            this.redisClient = RedisClient.create((RedisURI)this.connectUri);
            this.redisConnection = this.redisClient.connect();
            this.SubConnection = this.redisClient.connectPubSub();
            this.PubConnection = this.redisClient.connectPubSub();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.redisConnection != null) {
            this.redisConnection.close();
        }
        if (this.PubConnection != null) {
            this.PubConnection.close();
        }
        if (this.SubConnection != null) {
            this.SubConnection.close();
        }
        if (this.redisClient != null) {
            this.redisClient.shutdown();
            this.redisClient = null;
        }
        this.connectUri = null;
        this.redisConnection = null;
        this.PubConnection = null;
        this.SubConnection = null;
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public StatefulRedisPubSubConnection<String, String> getSubConnection() {
        return this.SubConnection;
    }

    public StatefulRedisPubSubConnection<String, String> getPubConnection() {
        return this.PubConnection;
    }

    public StatefulRedisConnection<String, String> getRedisConnection() {
        return this.redisConnection;
    }

    public RedisURI getConnectUri() {
        return this.connectUri;
    }

    public void init() {
        System.out.println("Redis Connecting...");
        this.connect();
        System.out.println("Redis Connected.");
    }

    public String getName() {
        return "";
    }

    public void register(RedisService obj) {
    }

    public LogServiceOld getLogger() {
        return null;
    }
}

