/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.mcs.services;

import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import com.snaju.nebula.utils.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.CRC32C;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;

@Singleton
public class EncryptionService
implements Service<EncryptionService> {
    private static final int SRS3_TYPE_IP = 1;
    private static final int SRS_IV_LEN = 12;
    private static final int SRS_TAG_LEN = 16;
    private static final int SRS_HEADER_LEN = 2;
    private static final int SRS_CRC_LEN = 4;
    private static final int PLAINTEXT_LEN = 998;
    private static final int MAX_PAYLOAD = 996;
    private static final int FINAL_FRAME_LEN = 1030;

    public String getName() {
        return "EncryptionService";
    }

    public void register(EncryptionService obj) {
    }

    public LogServiceOld getLogger() {
        return null;
    }

    private byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private static short buildSrs3Header(int type, int payloadLen) {
        int header = (type & 0xF) << 11 | payloadLen & 0x7FF;
        return (short)header;
    }

    public byte[] frame(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecureRandom random = new SecureRandom();
        CRC32C crc32c = new CRC32C();
        ByteBuffer plaintext = ByteBuffer.allocate(998);
        plaintext.order(ByteOrder.BIG_ENDIAN);
        short header = EncryptionService.buildSrs3Header(0, data.length);
        plaintext.putShort(header);
        BufferUtil.push((ByteBuffer)plaintext, (byte[])data);
        byte[] pt = plaintext.array();
        crc32c.reset();
        crc32c.update(pt, 0, pt.length);
        long crcValue = crc32c.getValue();
        ByteBuffer frame = ByteBuffer.allocate(pt.length + 4);
        BufferUtil.push((ByteBuffer)frame, (byte[])pt);
        frame.putInt((int)crcValue);
        return frame.array();
    }

    public byte[] encrypt(byte[] data, String rxKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecureRandom random = new SecureRandom();
        CRC32C crc32c = new CRC32C();
        ByteBuffer plaintext = ByteBuffer.allocate(998);
        plaintext.order(ByteOrder.BIG_ENDIAN);
        short header = EncryptionService.buildSrs3Header(0, data.length);
        plaintext.putShort(header);
        plaintext.put(data);
        while (plaintext.position() < 998) {
            plaintext.put((byte)0);
        }
        byte[] pt = plaintext.array();
        byte[] iv = new byte[12];
        random.nextBytes(iv);
        SecretKeySpec keySpec = new SecretKeySpec(this.hexToBytes(rxKey), "AES");
        GCMParameterSpec gcm = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)keySpec, gcm);
        byte[] ctAndTag = cipher.doFinal(pt);
        if (ctAndTag.length != 1014) {
            System.err.println("Unexpected GCM length: " + ctAndTag.length);
        }
        byte[] ciphertext = Arrays.copyOfRange(ctAndTag, 0, 998);
        byte[] tag = Arrays.copyOfRange(ctAndTag, 998, 1014);
        crc32c.reset();
        crc32c.update(iv, 0, iv.length);
        crc32c.update(ciphertext, 0, ciphertext.length);
        crc32c.update(tag, 0, tag.length);
        long crcValue = crc32c.getValue();
        ByteBuffer frame = ByteBuffer.allocate(1030);
        frame.put(iv);
        frame.put(ciphertext);
        frame.put(tag);
        frame.putInt((int)crcValue);
        return frame.array();
    }

    public byte[] decrypt(byte[] data, String txKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (data.length != 1030) {
            throw new IllegalBlockSizeException("Invalid frame length: " + data.length + ". Expected: " + 1030);
        }
        ByteBuffer frame = ByteBuffer.wrap(data);
        frame.order(ByteOrder.BIG_ENDIAN);
        byte[] iv = new byte[12];
        frame.get(iv);
        byte[] ciphertext = new byte[998];
        frame.get(ciphertext);
        byte[] tag = new byte[16];
        frame.get(tag);
        int receivedCrc = frame.getInt();
        CRC32C crc32c = new CRC32C();
        crc32c.update(iv, 0, iv.length);
        crc32c.update(ciphertext, 0, ciphertext.length);
        crc32c.update(tag, 0, tag.length);
        if ((int)crc32c.getValue() != receivedCrc) {
            throw new BadPaddingException("CRC32C Integrity Check Failed. Data may be corrupted.");
        }
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(this.hexToBytes(txKey), "AES");
        GCMParameterSpec gcm = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)keySpec, gcm);
        ByteBuffer decryptInput = ByteBuffer.allocate(ciphertext.length + tag.length);
        decryptInput.put(ciphertext);
        decryptInput.put(tag);
        byte[] plaintextWithHeader = cipher.doFinal(decryptInput.array());
        return plaintextWithHeader;
    }
}

