/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.watchdog.Watchdog;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

@Singleton
public class WatchdogService
implements Service {
    private ConcurrentHashMap<Class, Object> watchdogs = new ConcurrentHashMap();
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    @Override
    public void init() {
        System.out.println(this.ls.info("--- Watchdog Service"));
        Reflections reflections = this.getReflections();
        for (Class c : reflections.getSubTypesOf(WatchdogService.class)) {
            if (c.getAnnotation(Watchdog.class) == null) continue;
            this.watchdogs.put(c, SpaceSDK.getInstance().getInjector().getInstance(c));
        }
    }

    private Reflections getReflections() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()})).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
        return reflections;
    }

    public ConcurrentHashMap<Class, Object> getWatchdogs() {
        return this.watchdogs;
    }

    @Override
    public String getName() {
        return "Watchdog";
    }

    public void register(Object obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return this.ls;
    }
}

