/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.comm.CommAdapter;
import com.snaju.nebula.entities.comm.MessageHandler;
import com.snaju.nebula.entities.comm.Packet;
import com.snaju.nebula.injection.GuiceServiceLoader;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import com.snaju.nebula.service.ThreadService;
import java.util.HashMap;
import java.util.LinkedList;

@Singleton
public class CommService
implements Service<CommService> {
    @Inject
    private ThreadService threadService;
    private static HashMap<Class, CommAdapter> adapters = new HashMap();
    private static LinkedList<MessageHandler> handlers = new LinkedList();
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    @Override
    public String getName() {
        return "Communication";
    }

    @Override
    public void init() {
        System.out.println(this.ls.info("---- Communication Service"));
        GuiceServiceLoader.load(CommAdapter.class, SpaceSDK.getInstance().getClass().getClassLoader()).forEach(this::register);
    }

    @Override
    public void register(CommService obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return this.ls;
    }

    public void handle(Packet packet) {
        for (MessageHandler handler : handlers) {
            MessageHandler typedHandler;
            if (!handler.getType().isInstance(packet) || !(typedHandler = handler).route(packet)) continue;
            return;
        }
    }

    public void registerHandler(MessageHandler messageHandler) {
        handlers.add(messageHandler);
    }

    @Override
    public void register(CommAdapter adapter) {
        System.out.println(this.ls.info("Registering Comm Adapter: " + adapter.getClass().getSimpleName()));
        adapters.put(adapter.getClass(), adapter);
    }

    public void register(CommAdapter adapter, boolean autoStart) {
        this.threadService.runDedicatedThread("adapter" + adapter.getClass().getSimpleName() + "Starter", () -> {
            if (autoStart) {
                System.out.println("Starting up " + adapter.getClass().getSimpleName() + " Adapter...");
                adapter.connect();
            }
            this.register(adapter);
        });
    }

    public <T> T getAdapterOfType(Class<T> c) {
        return SpaceSDK.inject(c);
    }

    public static HashMap<Class, CommAdapter> getAdapters() {
        return adapters;
    }
}

