/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.lowentry.pyronet.udp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.event.PyroServerUdpListener;

public class PyroServerUdp {
    protected final DatagramChannel channel;
    private final Thread networkThread = Thread.currentThread();
    private final PyroServerUdpListener listener;

    public PyroServerUdp(InetSocketAddress end, PyroServerUdpListener listener) throws Exception {
        this.listener = listener;
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.channel.bind(end);
    }

    public PyroServerUdp(int port, PyroServerUdpListener listener) throws Exception {
        this(new InetSocketAddress(port), listener);
    }

    public PyroServerUdp(boolean acceptExternalConnections, int port, PyroServerUdpListener listener) throws Exception {
        this(new InetSocketAddress(acceptExternalConnections ? null : InetAddress.getLoopbackAddress(), port), listener);
    }

    public void shutdown() {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isNetworkThread() {
        return this.networkThread == Thread.currentThread();
    }

    public final Thread networkThread() {
        return this.networkThread;
    }

    public final void checkThread() {
        if (!this.isNetworkThread()) {
            throw new PyroException("call from outside the network-thread, you must schedule tasks");
        }
    }

    public void write(ByteBuffer buffer, SocketAddress client) {
        if (buffer == null) {
            return;
        }
        int pos = buffer.position();
        try {
            this.channel.send(buffer, client);
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer.position(pos);
    }

    public void listen(ByteBuffer buffer) {
        SocketAddress client = this.receive(buffer);
        while (client != null) {
            this.listener.receivedDataUdp(client, buffer);
            client = this.receive(buffer);
        }
    }

    private SocketAddress receive(ByteBuffer buffer) {
        try {
            buffer.clear();
            SocketAddress client = this.channel.receive(buffer);
            if (client == null) {
                return null;
            }
            buffer.flip();
            return client;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getLocalPort() {
        int port = this.channel.socket().getLocalPort();
        if (port <= 0) {
            return 0;
        }
        return port;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public final String getAddressText() {
        if (!this.channel.isOpen()) {
            return "closed";
        }
        DatagramSocket sockaddr = this.channel.socket();
        if (sockaddr == null) {
            return "connecting";
        }
        InetAddress inetaddr = sockaddr.getLocalAddress();
        if (inetaddr == null) {
            return "connecting";
        }
        return inetaddr.getHostAddress() + ":" + sockaddr.getLocalPort();
    }
}

