/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import lowentry.ue4.classes.RsaKeys;
import lowentry.ue4.classes.RsaPublicKey;
import lowentry.ue4.library.LowEntry;

public class ExampleEncryptionRsa {
    public static void main(String[] args) throws Throwable {
        RsaKeys keysA = LowEntry.generateRsaKeys(1024);
        RsaKeys keysB = LowEntry.generateRsaKeys(1024);
        byte[] publicKeyBytesB = LowEntry.rsaPublicKeyToBytes(keysB.publicKey);
        RsaPublicKey publicKeyB = LowEntry.bytesToRsaPublicKey(publicKeyBytesB);
        byte[] dataForB = LowEntry.stringToBytesUtf8("hello B!!");
        byte[] encryptedDataForB = LowEntry.encryptRsa(dataForB, publicKeyB);
        byte[] dataForMe = LowEntry.decryptRsa(encryptedDataForB, keysB.privateKey);
        System.out.println(LowEntry.areBytesEqual(dataForB, dataForMe));
        byte[] publicKeyBytesA = LowEntry.rsaPublicKeyToBytes(keysA.publicKey);
        RsaPublicKey publicKeyA = LowEntry.bytesToRsaPublicKey(publicKeyBytesA);
        byte[] dataForA = LowEntry.stringToBytesUtf8("hello a!!!!1!1");
        byte[] encryptedDataForA = LowEntry.encryptRsa(dataForA, publicKeyA);
        dataForMe = LowEntry.decryptRsa(encryptedDataForA, keysA.privateKey);
        System.out.println(LowEntry.areBytesEqual(dataForA, dataForMe));
        System.out.println();
        System.out.println("Keys A:");
        byte[] data = LowEntry.stringToBytesUtf8("test 12345");
        System.out.println("data:        " + LowEntry.bytesToHex(data));
        byte[] encrypted = LowEntry.encryptRsa(data, keysA.publicKey);
        System.out.println("encrypted:   " + LowEntry.bytesToHex(encrypted));
        byte[] decrypted = LowEntry.decryptRsa(encrypted, keysA.privateKey);
        System.out.println("decrypted:   " + LowEntry.bytesToHex(decrypted));
        System.out.println("public key:  " + LowEntry.bytesToHex(LowEntry.rsaPublicKeyToBytes(keysA.publicKey)));
        System.out.println("private key: " + LowEntry.bytesToHex(LowEntry.rsaPrivateKeyToBytes(keysA.privateKey)));
        System.out.println();
        System.out.println("Keys B:");
        data = LowEntry.stringToBytesUtf8("test 12345");
        System.out.println("data:        " + LowEntry.bytesToHex(data));
        encrypted = LowEntry.encryptRsa(data, keysB.publicKey);
        System.out.println("encrypted:   " + LowEntry.bytesToHex(encrypted));
        decrypted = LowEntry.decryptRsa(encrypted, keysB.privateKey);
        System.out.println("decrypted:   " + LowEntry.bytesToHex(decrypted));
        System.out.println("public key:  " + LowEntry.bytesToHex(LowEntry.rsaPublicKeyToBytes(keysB.publicKey)));
        System.out.println("private key: " + LowEntry.bytesToHex(LowEntry.rsaPrivateKeyToBytes(keysB.privateKey)));
    }
}

