/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import lowentry.ue4.classes.sockets.SocketFunctions;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;

public class SocketClient {
    protected final SocketServer server;
    protected final PyroClient client;
    protected SocketAddress clientUdpAddress = null;
    protected volatile Object attachment;
    protected boolean isDisconnecting = false;
    protected boolean isHandshakeCompleted = false;
    protected boolean isWebsocket = false;
    protected Collection<byte[]> bufferedMessagesDuringHandshake = null;
    protected volatile String addressText = null;
    protected final int hashCode;

    public SocketClient(SocketServer server, PyroClient client) {
        this.server = server;
        this.client = client;
        this.hashCode = super.hashCode();
    }

    protected void setRemoteUdpAddress(SocketAddress address) {
        if (this.client.selector().isNetworkThread()) {
            this.setRemoteUdpAddressCode(address);
        } else {
            this.client.selector().scheduleTask(() -> this.setRemoteUdpAddressCode(address));
        }
    }

    protected void setRemoteUdpAddressCode(SocketAddress address) {
        SocketAddress currentClientUdpAddress = this.clientUdpAddress;
        if (currentClientUdpAddress == null ? address == null : currentClientUdpAddress.equals(address)) {
            return;
        }
        if (SocketServer.IS_DEBUGGING) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " has UDP address: " + address);
        }
        this.clientUdpAddress = address;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public InetSocketAddress getLocalAddress() {
        return this.client.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.client.getRemoteAddress();
    }

    public InetAddress getIp() {
        return this.client.getInetAddress();
    }

    public String getIpString() {
        InetAddress ip = this.getIp();
        if (ip == null) {
            return null;
        }
        return ip.getHostAddress();
    }

    protected void onHandshakeCompletedTcp(boolean isWebsocket) {
        if (this.isHandshakeCompleted) {
            return;
        }
        this.isWebsocket = isWebsocket;
    }

    protected void onHandshakeCompletedUdp() {
        this.onHandshakeCompleted();
    }

    private void onHandshakeCompleted() {
        if (this.isHandshakeCompleted) {
            return;
        }
        this.isHandshakeCompleted = true;
        if (this.bufferedMessagesDuringHandshake != null) {
            for (byte[] message : this.bufferedMessagesDuringHandshake) {
                this.sendMessage(message);
            }
            this.bufferedMessagesDuringHandshake = null;
        }
    }

    protected boolean isHandshakeCompleted() {
        return this.isHandshakeCompleted;
    }

    protected boolean isWebsocket() {
        return this.isWebsocket;
    }

    public void sendUnreliableMessage(byte[] ... bytes) {
        this.sendUnreliableMessage(LowEntry.mergeBytes(bytes));
    }

    public void sendUnreliableMessage(byte[] bytes) {
        if (this.client.selector().isNetworkThread()) {
            if (bytes == null) {
                this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true);
            } else {
                this.sendUnreliableMessageCode(ByteBuffer.wrap(bytes), true);
            }
        } else if (bytes == null) {
            this.client.selector().scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true));
        } else {
            this.client.selector().scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.wrap(bytes), true));
        }
    }

    public void sendUnreliableMessage(ByteBuffer bytes) {
        if (this.client.selector().isNetworkThread()) {
            if (bytes == null) {
                this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true);
            } else {
                this.sendUnreliableMessageCode(bytes, false);
            }
        } else if (bytes == null) {
            this.client.selector().scheduleTask(() -> this.sendUnreliableMessageCode(ByteBuffer.allocate(0), true));
        } else {
            ByteBuffer b = LowEntry.cloneByteBuffer(bytes, false);
            this.client.selector().scheduleTask(() -> this.sendUnreliableMessageCode(b, true));
        }
    }

    protected void sendUnreliableMessageCode(ByteBuffer bytes, boolean clonedBytes) {
        block11: {
            if (this.server.serverUdp == null) {
                return;
            }
            if (this.isWebsocket()) {
                if (!this.isConnected()) {
                    return;
                }
                if (!this.isHandshakeCompleted()) {
                    return;
                }
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(bytes.remaining()) + bytes.remaining();
                ByteBuffer buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(bytes.remaining()));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
                buffer.put((byte)10);
                SocketFunctions.putUint(buffer, bytes.remaining());
                buffer.flip();
                try {
                    this.client.write(buffer);
                    if (bytes.remaining() <= 0) break block11;
                    if (clonedBytes) {
                        this.client.write(bytes);
                        break block11;
                    }
                    this.client.writeCopy(bytes);
                }
                catch (PyroException e) {
                    if (SocketServer.IS_DEBUGGING) {
                        SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send an unreliable message:");
                        SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                    }
                    break block11;
                }
            }
            if (!this.isConnectedUdp()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                return;
            }
            SocketAddress currentClientUdpAddress = this.clientUdpAddress;
            if (currentClientUdpAddress == null) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(1 + bytes.remaining());
            buffer.put((byte)2);
            buffer.put(bytes);
            buffer.flip();
            this.server.serverUdp.write(buffer, currentClientUdpAddress);
        }
    }

    public void sendMessage(byte[] ... bytes) {
        this.sendMessage(LowEntry.mergeBytes(bytes));
    }

    public void sendMessage(byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.client.selector().isNetworkThread()) {
            this.sendMessageCode(b);
        } else {
            this.client.selector().scheduleTask(() -> this.sendMessageCode(b));
        }
    }

    protected void sendMessageCode(byte[] bytes) {
        block8: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                if (this.bufferedMessagesDuringHandshake == null) {
                    this.bufferedMessagesDuringHandshake = new ArrayList<byte[]>();
                }
                this.bufferedMessagesDuringHandshake.add(bytes);
                return;
            }
            if (this.isWebsocket()) {
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(bytes.length) + bytes.length;
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(bytes.length));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
            } else {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(bytes.length));
            }
            buffer.put((byte)1);
            SocketFunctions.putUint(buffer, bytes.length);
            buffer.flip();
            try {
                this.client.write(buffer);
                if (bytes.length > 0) {
                    this.client.write(ByteBuffer.wrap(bytes));
                }
            }
            catch (PyroException e) {
                if (!SocketServer.IS_DEBUGGING) break block8;
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a message:");
                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    protected void sendFunctionCallResponse(int functionCallId, byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.client.selector().isNetworkThread()) {
            this.sendFunctionCallResponseCode(functionCallId, b);
        } else {
            this.client.selector().scheduleTask(() -> this.sendFunctionCallResponseCode(functionCallId, b));
        }
    }

    protected void sendFunctionCallResponseCode(int functionCallId, byte[] bytes) {
        block7: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length) + bytes.length;
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
            } else {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length));
            }
            buffer.put((byte)3);
            SocketFunctions.putUint(buffer, functionCallId);
            SocketFunctions.putUint(buffer, bytes.length);
            buffer.flip();
            try {
                this.client.write(buffer);
                if (bytes.length > 0) {
                    this.client.write(ByteBuffer.wrap(bytes));
                }
            }
            catch (PyroException e) {
                if (!SocketServer.IS_DEBUGGING) break block7;
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a function call response:");
                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    protected void sendLatentFunctionCallResponse(int functionCallId, byte[] bytes) {
        byte[] b;
        byte[] byArray = b = bytes == null ? new byte[]{} : bytes;
        if (this.client.selector().isNetworkThread()) {
            this.sendLatentFunctionCallResponseCode(functionCallId, b);
        } else {
            this.client.selector().scheduleTask(() -> this.sendLatentFunctionCallResponseCode(functionCallId, b));
        }
    }

    protected void sendLatentFunctionCallResponseCode(int functionCallId, byte[] bytes) {
        block7: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length) + bytes.length;
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
            } else {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId) + SocketFunctions.uintByteCount(bytes.length));
            }
            buffer.put((byte)5);
            SocketFunctions.putUint(buffer, functionCallId);
            SocketFunctions.putUint(buffer, bytes.length);
            buffer.flip();
            try {
                this.client.write(buffer);
                if (bytes.length > 0) {
                    this.client.write(ByteBuffer.wrap(bytes));
                }
            }
            catch (PyroException e) {
                if (!SocketServer.IS_DEBUGGING) break block7;
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a latent function call response:");
                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    protected void sendLatentFunctionCallCancel(int functionCallId) {
        if (this.client.selector().isNetworkThread()) {
            this.sendLatentFunctionCallCancelCode(functionCallId);
        } else {
            this.client.selector().scheduleTask(() -> this.sendLatentFunctionCallCancelCode(functionCallId));
        }
    }

    protected void sendLatentFunctionCallCancelCode(int functionCallId) {
        block6: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(functionCallId);
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(functionCallId));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
            } else {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId));
            }
            buffer.put((byte)6);
            SocketFunctions.putUint(buffer, functionCallId);
            buffer.flip();
            try {
                this.client.write(buffer);
            }
            catch (PyroException e) {
                if (!SocketServer.IS_DEBUGGING) break block6;
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a latent function call cancel:");
                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    protected void sendConnectionValidationResponse(int functionCallId) {
        if (this.client.selector().isNetworkThread()) {
            this.sendConnectionValidationResponseCode(functionCallId);
        } else {
            this.client.selector().scheduleTask(() -> this.sendConnectionValidationResponseCode(functionCallId));
        }
    }

    protected void sendConnectionValidationResponseCode(int functionCallId) {
        block6: {
            ByteBuffer buffer;
            if (!this.isConnected()) {
                return;
            }
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                byte opcode = -126;
                int size = 1 + SocketFunctions.uintByteCount(functionCallId);
                buffer = ByteBuffer.allocate(1 + SocketFunctions.websocketSizeByteCount(size) + 1 + SocketFunctions.uintByteCount(functionCallId));
                buffer.put(opcode);
                SocketFunctions.putWebsocketSizeBytes(buffer, size);
            } else {
                buffer = ByteBuffer.allocate(1 + SocketFunctions.uintByteCount(functionCallId));
            }
            buffer.put((byte)8);
            SocketFunctions.putUint(buffer, functionCallId);
            buffer.flip();
            try {
                this.client.write(buffer);
            }
            catch (PyroException e) {
                if (!SocketServer.IS_DEBUGGING) break block6;
                SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send a connection validation response:");
                SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    public void disconnect() {
        if (this.client.selector().isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.sendCloseMessage();
            this.client.shutdown();
        } else {
            this.client.selector().scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                this.sendCloseMessage();
                this.client.shutdown();
            });
        }
    }

    public void disconnectImmediately() {
        if (this.client.selector().isNetworkThread()) {
            if (this.isDisconnecting) {
                return;
            }
            this.isDisconnecting = true;
            this.client.dropConnection();
        } else {
            this.client.selector().scheduleTask(() -> {
                if (this.isDisconnecting) {
                    return;
                }
                this.isDisconnecting = true;
                this.client.dropConnection();
            });
        }
    }

    protected void sendCloseMessage() {
        block4: {
            if (!this.isHandshakeCompleted()) {
                return;
            }
            if (this.isWebsocket()) {
                try {
                    this.client.write(ByteBuffer.wrap(new byte[]{-120}));
                }
                catch (PyroException e) {
                    if (!SocketServer.IS_DEBUGGING) break block4;
                    SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " can't be send FIN + CLOSE (websocket):");
                    SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
                }
            }
        }
    }

    public boolean isConnected() {
        this.client.selector().checkThread();
        return !this.isDisconnecting && !this.client.isDisconnected();
    }

    protected boolean isConnectedUdp() {
        return !this.isDisconnecting;
    }

    public PyroClient pyro() {
        return this.client;
    }

    public SocketServer server() {
        return this.server;
    }

    public PyroSelector selector() {
        return this.client.selector();
    }

    public void execute(Runnable runnable) {
        if (this.client.selector().isNetworkThread()) {
            runnable.run();
        } else {
            this.client.selector().scheduleTask(runnable);
        }
    }

    public boolean isNetworkThread() {
        return this.client.selector().isNetworkThread();
    }

    protected void saveAddressText() {
        if (this.client == null) {
            this.addressText = "closed";
            return;
        }
        this.addressText = this.client.getAddressText();
    }

    public String getAddressText() {
        String addressText = this.addressText;
        if (addressText != null) {
            return addressText;
        }
        if (this.client == null) {
            return "closed";
        }
        return this.client.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

