/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import lowentry.ue4.classes.ByteDataReader;

public abstract class SimpleByteDataReader
extends ByteDataReader {
    @Override
    protected int getUinteger() {
        int value = this._getUinteger();
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    private int _getUinteger() {
        int pos;
        int count = this.getTotalCountImplementation();
        if (count <= (pos = this.getAndIncreasePosition(4))) {
            return 0;
        }
        if (count <= pos + 1) {
            return this.getByteImplementation(pos) & 0xFF;
        }
        if (count <= pos + 2) {
            return (this.getByteImplementation(pos) & 0xFF) << 8 | this.getByteImplementation(pos + 1) & 0xFF;
        }
        if (count <= pos + 3) {
            return (this.getByteImplementation(pos) & 0xFF) << 16 | (this.getByteImplementation(pos + 1) & 0xFF) << 8 | this.getByteImplementation(pos + 2) & 0xFF;
        }
        return (this.getByteImplementation(pos) & 0xFF) << 24 | (this.getByteImplementation(pos + 1) & 0xFF) << 16 | (this.getByteImplementation(pos + 2) & 0xFF) << 8 | this.getByteImplementation(pos + 3) & 0xFF;
    }

    @Override
    public boolean[] getBooleanArray() {
        int length = this.getUinteger();
        if ((length = Math.min(length, this.maxElementsRemaining(1))) <= 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.getBoolean();
        }
        return array;
    }
}

