/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.udpbridge;

import com.google.inject.Inject;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.snaju.nebula.entities.socket.udp.NebulaUDPListener;
import com.snaju.nebula.entities.task.NebulaTask;
import com.snaju.nebula.entities.task.TickUnit;
import com.snaju.nebula.entities.task.types.RepeatingTask;
import com.snaju.nebula.service.CommService;
import com.snaju.nebula.service.TaskService;
import com.spacenetwork.leafspace.LeafSpaceCommAdapter;
import com.spacenetwork.leafspace.LeafSpaceSandboxCommAdapter;
import com.spacenetwork.mcs.entites.comm.obj.PayloadPair;
import com.spacenetwork.mcs.services.CSPPacketProcessor;
import com.spacenetwork.mcs.services.EncryptionService;
import com.spacenetwork.mcs.services.EnvironmentConfigService;
import com.spacenetwork.mcs.services.RedisService;
import com.spacenetwork.mcs.services.SNCommService;
import fr.devnied.bitlib.BytesUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class UDPBridgePlugin
extends SpacePlugin {
    private static final int UDP_PORT = 52005;
    private static final int DEFAULT_SATELLITE_ID = 1;
    @Inject
    private EnvironmentConfigService envConfig;
    @Inject
    private SNCommService snCommService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private CSPPacketProcessor cspProcessor;
    private NebulaUDPListener udpListener;
    private DatagramSocket udpSocket;
    private volatile InetAddress lastClientAddress;
    private volatile int lastClientPort;

    public void onEnable() {
        try {
            System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551         UDP BRIDGE PLUGIN STARTING                            \u2551");
            System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
            System.out.println("\u2551 UDP Listen Port: 52005");
            String mode = this.envConfig != null ? this.envConfig.getEnvironmentMode() : "unknown";
            System.out.println("\u2551 Environment Mode: '" + mode + "'");
            System.out.println("\u2551 Mode check result: flatsat=" + "flatsat".equalsIgnoreCase(mode));
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
            this.udpSocket = new DatagramSocket(52005);
            System.out.println("\ud83d\udce1 UDP Socket bound to port 52005");
            this.udpListener = new NebulaUDPListener(this.udpSocket){

                protected void processPacket(byte[] data, InetAddress address, int port) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
                    UDPBridgePlugin.this.handleIncomingUDPPacket(data, address, port);
                }

                protected void handleError(Exception e) {
                    System.err.println("\u274c UDP Bridge Error: " + e.getMessage());
                    e.printStackTrace();
                }
            };
            this.udpListener.start();
            if ("flatsat".equalsIgnoreCase(mode)) {
                this.registerFlatSatDownlinkListener();
                this.startResponseMonitor();
            } else {
                this.registerFlightDownlinkListener();
            }
            System.out.println("\u2705 UDP Bridge Plugin enabled successfully");
        }
        catch (IOException e) {
            System.err.println("\u274c Failed to start UDP Bridge Plugin");
            e.printStackTrace();
        }
    }

    private void startResponseMonitor() {
        ((TaskService)SpaceSDK.inject(TaskService.class)).scheduleTask((NebulaTask)new RepeatingTask("udp-response-monitor", TickUnit.TICKS.toTicks(1L), TickUnit.TICKS.toTicks(1L), false){

            public void run() {
                try {
                    if (UDPBridgePlugin.this.lastClientAddress == null || UDPBridgePlugin.this.lastClientPort == 0) {
                        return;
                    }
                    RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
                    if (redisService == null || redisService.getRedisConnection() == null) {
                        return;
                    }
                    if (!redisService.getRedisConnection().isOpen()) {
                        return;
                    }
                    String ready = (String)redisService.getRedisConnection().sync().get((Object)"csp_output_ready");
                    if ("1".equals(ready)) {
                        String cspOutput = (String)redisService.getRedisConnection().sync().get((Object)"csp_output");
                        if (cspOutput != null && !cspOutput.isEmpty()) {
                            UDPBridgePlugin.this.sendResponseToClient(cspOutput);
                        }
                        redisService.getRedisConnection().sync().set((Object)"csp_output_ready", (Object)"0");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        System.out.println("\ud83d\udce1 Redis response monitor started (polling every tick ~50ms for csp_output_ready trigger)");
    }

    private void sendResponseToClient(String hexData) {
        try {
            if (this.lastClientAddress == null || this.lastClientPort == 0) {
                System.err.println("\u274c No client address/port to send response to");
                return;
            }
            byte[] responseData = this.hexStringToBytes(hexData);
            if (responseData.length == 0) {
                return;
            }
            DatagramPacket responsePacket = new DatagramPacket(responseData, responseData.length, this.lastClientAddress, this.lastClientPort);
            this.udpSocket.send(responsePacket);
            System.out.println("\ud83d\udce4 UDP Response sent to " + this.lastClientAddress + ":" + this.lastClientPort + " (" + responseData.length + " bytes)");
            System.out.println("   Data: " + hexData);
        }
        catch (Exception e) {
            System.err.println("\u274c Error sending UDP response: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private byte[] hexStringToBytes(String hex) {
        if (hex == null || hex.isEmpty()) {
            return new byte[0];
        }
        if ((hex = hex.replaceAll("\\s+", "").toUpperCase()).length() % 2 != 0) {
            System.err.println("\u26a0\ufe0f Invalid hex string length: " + hex.length());
            return new byte[0];
        }
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private void handleIncomingUDPPacket(byte[] data, InetAddress address, int port) {
        try {
            this.lastClientAddress = address;
            this.lastClientPort = port;
            int satelliteId = 1;
            byte[] cspPacket = data;
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\ud83d\udce8 [UDP IN] Packet received from " + address + ":" + port);
            System.out.println("   Size: " + data.length + " bytes");
            System.out.println("   Raw:  " + BytesUtils.bytesToString((byte[])data));
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            this.sendToMQTT(satelliteId, cspPacket);
        }
        catch (Exception e) {
            System.err.println("\u274c Error processing UDP packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void sendToMQTT(int satelliteId, byte[] cspPacket) {
        try {
            String mode = this.envConfig != null ? this.envConfig.getEnvironmentMode() : "production";
            System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551         UDP BRIDGE - SEND TO MQTT DEBUG                      \u2551");
            System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
            System.out.println("\u2551 Environment Mode: " + mode + "                                      \u2551");
            System.out.println("\u2551 CSP Packet Size: " + cspPacket.length + " bytes                                   \u2551");
            System.out.println("\u2551 CSP Packet (hex): " + BytesUtils.bytesToString((byte[])cspPacket));
            System.out.println("\u2560\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2563");
            CommService commService = (CommService)SpaceSDK.inject(CommService.class);
            if (commService == null) {
                System.out.println("\u2551 \u274c ERROR: CommService is NULL!                                \u2551");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                return;
            }
            System.out.println("\u2551 CommService: Available                                       \u2551");
            System.out.println("\u2551 Registered Adapters: " + CommService.getAdapters().keySet() + "  \u2551");
            if ("flatsat".equalsIgnoreCase(mode)) {
                System.out.println("\u2551 Mode: FlatSat - Looking for LeafSpaceSandboxCommAdapter      \u2551");
                LeafSpaceSandboxCommAdapter sandboxAdapter = (LeafSpaceSandboxCommAdapter)commService.getAdapterOfType(LeafSpaceSandboxCommAdapter.class);
                if (sandboxAdapter == null) {
                    System.out.println("\u2551 \u274c ERROR: LeafSpaceSandboxCommAdapter is NULL!                \u2551");
                    System.out.println("\u2551 Available adapters:                                          \u2551");
                    for (Object adapter : CommService.getAdapters().values()) {
                        System.out.println("\u2551   - " + adapter.getClass().getSimpleName() + "                              \u2551");
                    }
                    System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                    return;
                }
                System.out.println("\u2551 \u2705 LeafSpaceSandboxCommAdapter: Found                         \u2551");
                System.out.println("\u2551 Calling sandboxAdapter.sendUplink(1, cspPacket)...           \u2551");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                sandboxAdapter.sendUplink(1, cspPacket);
                System.out.println("\u2705 UDP->MQTT FlatSat: Sent CSP packet to SAT-1, " + cspPacket.length + " bytes");
            } else {
                System.out.println("\u2551 Mode: Flight - Looking for LeafSpaceCommAdapter              \u2551");
                LeafSpaceCommAdapter leafSpaceAdapter = (LeafSpaceCommAdapter)commService.getAdapterOfType(LeafSpaceCommAdapter.class);
                if (leafSpaceAdapter == null) {
                    System.out.println("\u2551 \u274c ERROR: LeafSpaceCommAdapter is NULL!                       \u2551");
                    System.out.println("\u2551 Available adapters:                                          \u2551");
                    for (Object adapter : CommService.getAdapters().values()) {
                        System.out.println("\u2551   - " + adapter.getClass().getSimpleName() + "                              \u2551");
                    }
                    System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                    return;
                }
                System.out.println("\u2551 \u2705 LeafSpaceCommAdapter: Found                                \u2551");
                System.out.println("\u2551 Calling leafSpaceAdapter.sendUplink(1, cspPacket)...         \u2551");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                leafSpaceAdapter.sendUplink(1, cspPacket, true);
                System.out.println("\u2705 UDP->MQTT Flight: Sent CSP packet to SAT-1, " + cspPacket.length + " bytes");
            }
        }
        catch (InterruptedException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            System.err.println("\u274c Error sending to MQTT: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("\u274c Unexpected error in sendToMQTT: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerFlatSatDownlinkListener() {
        System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551     REGISTERING FLATSAT DOWNLINK LISTENER                     \u2551");
        System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        CommService commService = (CommService)SpaceSDK.inject(CommService.class);
        if (commService == null) {
            System.err.println("\u2551 \u274c CommService is NULL!");
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
            return;
        }
        System.out.println("\u2551 CommService: Available");
        System.out.println("\u2551 Registered adapters: " + CommService.getAdapters().keySet());
        LeafSpaceSandboxCommAdapter sandboxAdapter = (LeafSpaceSandboxCommAdapter)commService.getAdapterOfType(LeafSpaceSandboxCommAdapter.class);
        if (sandboxAdapter == null) {
            System.err.println("\u2551 \u274c LeafSpaceSandboxCommAdapter is NULL!");
            System.out.println("\u2551 Available adapters:");
            for (Object adapter : CommService.getAdapters().values()) {
                System.out.println("\u2551   - " + adapter.getClass().getName());
            }
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
            return;
        }
        System.out.println("\u2551 \u2705 LeafSpaceSandboxCommAdapter: Found");
        sandboxAdapter.registerDownlinkListener((satelliteId, encryptedPayload) -> {
            System.out.println("\n\ud83d\udd14\ud83d\udd14\ud83d\udd14 DOWNLINK LISTENER CALLBACK TRIGGERED! \ud83d\udd14\ud83d\udd14\ud83d\udd14");
            System.out.println("   Satellite ID: " + satelliteId);
            System.out.println("   Payload size: " + ((byte[])encryptedPayload).length + " bytes");
            this.handleFlatSatDownlink((String)satelliteId, (byte[])encryptedPayload);
        });
        System.out.println("\u2551 \u2705 Downlink listener registered successfully");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
    }

    private void handleFlatSatDownlink(String satelliteId, byte[] encryptedPayload) {
        try {
            System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551     UDP BRIDGE - FLATSAT DOWNLINK RECEIVED                   \u2551");
            System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
            System.out.println("\u2551 From SAT-" + satelliteId);
            System.out.println("\u2551 Size: " + encryptedPayload.length + " bytes (encrypted)");
            System.out.println("\u2560\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2563");
            if (this.lastClientAddress == null || this.lastClientPort == 0) {
                System.out.println("\u2551 \u26a0\ufe0f No UDP client to send response to");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                return;
            }
            PayloadPair pair = ((SNCommService)SpaceSDK.inject(SNCommService.class)).getSatPair(1);
            if (pair == null) {
                System.out.println("\u2551 \u274c No PayloadPair found for satellite ID: 1");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                return;
            }
            String txKeyHex = UDPBridgePlugin.bytesToHex(pair.getTxKey());
            byte[] decryptedFrame = ((EncryptionService)SpaceSDK.inject(EncryptionService.class)).decrypt(encryptedPayload, txKeyHex);
            byte[] actualPayload = this.extractSrs3Payload(decryptedFrame);
            String packetType = this.detectPacketType(actualPayload);
            System.out.println("\u2551 Decrypted size: " + actualPayload.length + " bytes");
            System.out.println("\u2551 \u2605\u2605\u2605 RESPONSE TYPE: " + packetType + " \u2605\u2605\u2605");
            System.out.println("\u2551 Payload: " + BytesUtils.bytesToString((byte[])actualPayload));
            System.out.println("\u2560\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2563");
            this.sendBytesToClient(actualPayload);
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
        }
        catch (Exception e) {
            System.err.println("\u274c Error processing FlatSat downlink: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String detectPacketType(byte[] data) {
        if (data == null || data.length < 4) {
            return "UNKNOWN (too short)";
        }
        int firstByte = data[0] & 0xFF;
        int ipVersion = firstByte >> 4 & 0xF;
        if (ipVersion == 4 && data.length >= 20) {
            int protocol = data[9] & 0xFF;
            String srcIp = String.format("%d.%d.%d.%d", data[12] & 0xFF, data[13] & 0xFF, data[14] & 0xFF, data[15] & 0xFF);
            String dstIp = String.format("%d.%d.%d.%d", data[16] & 0xFF, data[17] & 0xFF, data[18] & 0xFF, data[19] & 0xFF);
            if (protocol == 1) {
                int icmpType;
                int n = icmpType = data.length > 20 ? data[20] & 0xFF : -1;
                String icmpTypeName = icmpType == 8 ? "Echo Request" : (icmpType == 0 ? "Echo Reply" : String.valueOf(icmpType));
                return "IP/ICMP (" + icmpTypeName + ") " + srcIp + " \u2192 " + dstIp;
            }
            if (protocol == 6) {
                return "IP/TCP " + srcIp + " \u2192 " + dstIp;
            }
            if (protocol == 17) {
                return "IP/UDP " + srcIp + " \u2192 " + dstIp;
            }
            return "IP/PROTO-" + protocol + " " + srcIp + " \u2192 " + dstIp;
        }
        if (data.length >= 4 && data.length < 100 && ipVersion != 4) {
            int header = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            int src = header >> 25 & 0x1F;
            int dst = header >> 20 & 0x1F;
            int dstPort = header >> 14 & 0x3F;
            int srcPort = header >> 8 & 0x3F;
            int flags = header & 0xFF;
            if (src <= 31 && dst <= 31 && dstPort <= 63 && srcPort <= 63) {
                return "CSP (src=" + src + " dst=" + dst + " sport=" + srcPort + " dport=" + dstPort + " flags=0x" + String.format("%02X", flags) + ")";
            }
            return "CSP (raw, " + data.length + " bytes)";
        }
        return "UNKNOWN (first byte: 0x" + String.format("%02X", firstByte) + ")";
    }

    private void registerFlightDownlinkListener() {
        CommService commService = (CommService)SpaceSDK.inject(CommService.class);
        LeafSpaceCommAdapter leafSpaceAdapter = (LeafSpaceCommAdapter)commService.getAdapterOfType(LeafSpaceCommAdapter.class);
        if (leafSpaceAdapter == null) {
            System.err.println("\u274c Cannot register flight downlink listener - LeafSpace adapter not available");
            return;
        }
        leafSpaceAdapter.registerDownlinkListener((satelliteId, payload) -> this.handleFlightDownlink((String)satelliteId, (byte[])payload));
        System.out.println("\ud83d\udce1 Flight mode: Registered MQTT downlink listener for response handling");
    }

    private void handleFlightDownlink(String satelliteId, byte[] encryptedPayload) {
        try {
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\ud83d\udce9 [MQTT DOWNLINK] Reply received from SAT-" + satelliteId);
            System.out.println("   Size: " + encryptedPayload.length + " bytes");
            System.out.println("   Raw:  " + BytesUtils.bytesToString((byte[])encryptedPayload));
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            if (this.lastClientAddress == null || this.lastClientPort == 0) {
                System.err.println("\u26a0\ufe0f No UDP client to send response to");
                return;
            }
            int satId = this.mapLeafSpaceIdToInternal(satelliteId);
            if (satId == -1) {
                System.err.println("\u274c Unknown satellite ID: " + satelliteId);
                return;
            }
            PayloadPair pair = ((SNCommService)SpaceSDK.inject(SNCommService.class)).getSatPair(satId);
            if (pair == null) {
                System.err.println("\u274c No PayloadPair found for satellite ID: " + satId);
                return;
            }
            String txKeyHex = UDPBridgePlugin.bytesToHex(pair.getTxKey());
            byte[] decryptedFrame = ((EncryptionService)SpaceSDK.inject(EncryptionService.class)).decrypt(encryptedPayload, txKeyHex);
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\ud83d\udd13 [DECRYPTED] Packet after decryption from SAT-" + satId);
            System.out.println("   Size: " + decryptedFrame.length + " bytes");
            System.out.println("   Raw:  " + BytesUtils.bytesToString((byte[])decryptedFrame));
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            byte[] actualPayload = this.extractSrs3Payload(decryptedFrame);
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\ud83d\udce6 [FINAL] Packet after removing header and zero padding");
            System.out.println("   Size: " + actualPayload.length + " bytes");
            System.out.println("   Data: " + BytesUtils.bytesToString((byte[])actualPayload));
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            this.sendBytesToClient(actualPayload);
        }
        catch (Exception e) {
            System.err.println("\u274c Error processing flight downlink: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int mapLeafSpaceIdToInternal(String leafSpaceId) {
        try {
            int lsId = Integer.parseInt(leafSpaceId);
            for (Map.Entry entry : SNCommService.idMaps.entrySet()) {
                if ((Integer)entry.getValue() != lsId) continue;
                return (Integer)entry.getKey();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private byte[] extractSrs3Payload(byte[] decryptedFrame) {
        if (decryptedFrame == null || decryptedFrame.length < 2) {
            return new byte[0];
        }
        int header = (decryptedFrame[0] & 0xFF) << 8 | decryptedFrame[1] & 0xFF;
        int payloadLength = header & 0x7FF;
        int type = header >> 12 & 0xF;
        System.out.println("   SRS-3 Header: type=" + type + ", length=" + payloadLength);
        if (payloadLength <= 0 || payloadLength > decryptedFrame.length - 2) {
            System.err.println("\u274c Invalid SRS-3 payload length: " + payloadLength);
            return new byte[0];
        }
        byte[] payload = new byte[payloadLength];
        System.arraycopy(decryptedFrame, 2, payload, 0, payloadLength);
        return payload;
    }

    private void sendBytesToClient(byte[] data) {
        try {
            if (this.lastClientAddress == null || this.lastClientPort == 0) {
                System.err.println("\u274c No client address/port to send response to");
                return;
            }
            if (data.length == 0) {
                System.err.println("\u26a0\ufe0f Empty payload, not sending");
                return;
            }
            DatagramPacket responsePacket = new DatagramPacket(data, data.length, this.lastClientAddress, this.lastClientPort);
            this.udpSocket.send(responsePacket);
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\ud83d\udce4 [UDP OUT] Response sent to " + this.lastClientAddress + ":" + this.lastClientPort);
            System.out.println("   Size: " + data.length + " bytes");
            System.out.println("   Data: " + BytesUtils.bytesToString((byte[])data));
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
        catch (Exception e) {
            System.err.println("\u274c Error sending UDP response: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void onDisable() {
        System.out.println("\ud83d\udd0c UDP Bridge Plugin disabling...");
        if (this.udpListener != null) {
            this.udpListener.stop();
            System.out.println("\u2705 UDP listener stopped");
        }
        if (this.udpSocket != null && !this.udpSocket.isClosed()) {
            this.udpSocket.close();
            System.out.println("\u2705 UDP socket closed");
        }
    }
}

