/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.tunnel;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int GCM_TAG_LENGTH_BITS = 128;
    private static final int GCM_IV_LENGTH_BYTES = 12;
    private static final SecureRandom RANDOM = new SecureRandom();

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] encrypt(byte[] data, byte[] keyBytes) throws Exception {
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException("Key must be 32 bytes for AES-256.");
        }
        byte[] iv = new byte[12];
        RANDOM.nextBytes(iv);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, ALGORITHM);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secretKey, parameterSpec);
        byte[] ciphertextWithTag = cipher.doFinal(data);
        byte[] result = new byte[12 + ciphertextWithTag.length];
        System.arraycopy(iv, 0, result, 0, 12);
        System.arraycopy(ciphertextWithTag, 0, result, 12, ciphertextWithTag.length);
        return result;
    }

    public static byte[] decrypt(byte[] encryptedData, byte[] keyBytes) throws Exception {
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException("Key must be 32 bytes for AES-256.");
        }
        if (encryptedData.length < 28) {
            throw new BadPaddingException("Ciphertext too short to contain IV and Tag.");
        }
        byte[] iv = Arrays.copyOfRange(encryptedData, 0, 12);
        byte[] ciphertextWithTag = Arrays.copyOfRange(encryptedData, 12, encryptedData.length);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, ALGORITHM);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)secretKey, parameterSpec);
        return cipher.doFinal(ciphertextWithTag);
    }
}

