/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal.aes;

import lowentry.ue4.classes.AesKey;
import lowentry.ue4.classes.internal.aes.EncryptionAesFastEngineGeneral_NonJava;

public class EncryptionAesFastEngine_NonJava {
    private final int ROUNDS;
    private final int[][] EW;
    private final int[][] DW;
    public int C0 = 0;
    public int C1 = 0;
    public int C2 = 0;
    public int C3 = 0;
    public int C0store1 = 0;
    public int C1store1 = 0;
    public int C2store1 = 0;
    public int C3store1 = 0;
    public int C0store2 = 0;
    public int C1store2 = 0;
    public int C2store2 = 0;
    public int C3store2 = 0;

    public EncryptionAesFastEngine_NonJava(AesKey key) {
        this.ROUNDS = key.rounds;
        this.EW = key.encryptionW;
        this.DW = key.decryptionW;
    }

    private static int s(int a, int b) {
        return a >>> b;
    }

    public static AesKey generateAesKey(byte[] key) {
        return EncryptionAesFastEngine_NonJava.generateAesKeyCustom(key, true, true);
    }

    public static AesKey generateAesKeyCustom(byte[] key, boolean forEncryption, boolean forDecryption) {
        if (key == null) {
            return null;
        }
        int keyLen = key.length;
        if (keyLen != 16 && keyLen != 24 & keyLen != 32) {
            return null;
        }
        int kc = EncryptionAesFastEngine_NonJava.s(keyLen, 2);
        int rounds = kc + 6;
        if (!forEncryption && !forDecryption) {
            return new AesKey(rounds, null, null);
        }
        int[][] ew = new int[rounds + 1][4];
        switch (kc) {
            case 4: {
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0][0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[0][1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[0][2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[0][3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                for (int i = 1; i <= 10; ++i) {
                    int u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t3, 8)) ^ EncryptionAesFastEngineGeneral_NonJava.rcon[i - 1];
                    ew[i][0] = t0 ^= u;
                    ew[i][1] = t1 ^= t0;
                    ew[i][2] = t2 ^= t1;
                    ew[i][3] = t3 ^= t2;
                }
                break;
            }
            case 6: {
                int t5;
                int t4;
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0][0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[0][1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[0][2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[0][3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                ew[1][0] = t4 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 16);
                ew[1][1] = t5 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 20);
                int rcon = 1;
                int u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                rcon <<= 1;
                ew[1][2] = t0 ^= u;
                ew[1][3] = t1 ^= t0;
                ew[2][0] = t2 ^= t1;
                ew[2][1] = t3 ^= t2;
                ew[2][2] = t4 ^= t3;
                ew[2][3] = t5 ^= t4;
                for (int i = 3; i < 12; i += 3) {
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[i][0] = t0 ^= u;
                    ew[i][1] = t1 ^= t0;
                    ew[i][2] = t2 ^= t1;
                    ew[i][3] = t3 ^= t2;
                    ew[i + 1][0] = t4 ^= t3;
                    ew[i + 1][1] = t5 ^= t4;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[i + 1][2] = t0 ^= u;
                    ew[i + 1][3] = t1 ^= t0;
                    ew[i + 2][0] = t2 ^= t1;
                    ew[i + 2][1] = t3 ^= t2;
                    ew[i + 2][2] = t4 ^= t3;
                    ew[i + 2][3] = t5 ^= t4;
                }
                u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t5, 8)) ^ rcon;
                ew[12][0] = t0 ^= u;
                ew[12][1] = t1 ^= t0;
                ew[12][2] = t2 ^= t1;
                ew[12][3] = t3 ^= t2;
                break;
            }
            case 8: {
                int u;
                int t7;
                int t6;
                int t5;
                int t4;
                int t3;
                int t2;
                int t1;
                int t0;
                ew[0][0] = t0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 0);
                ew[0][1] = t1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 4);
                ew[0][2] = t2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 8);
                ew[0][3] = t3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 12);
                ew[1][0] = t4 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 16);
                ew[1][1] = t5 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 20);
                ew[1][2] = t6 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 24);
                ew[1][3] = t7 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(key, 28);
                int rcon = 1;
                for (int i = 2; i < 14; i += 2) {
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t7, 8)) ^ rcon;
                    rcon <<= 1;
                    ew[i][0] = t0 ^= u;
                    ew[i][1] = t1 ^= t0;
                    ew[i][2] = t2 ^= t1;
                    ew[i][3] = t3 ^= t2;
                    u = EncryptionAesFastEngineGeneral_NonJava.subWord(t3);
                    ew[i + 1][0] = t4 ^= u;
                    ew[i + 1][1] = t5 ^= t4;
                    ew[i + 1][2] = t6 ^= t5;
                    ew[i + 1][3] = t7 ^= t6;
                }
                u = EncryptionAesFastEngineGeneral_NonJava.subWord(EncryptionAesFastEngineGeneral_NonJava.shift(t7, 8)) ^ rcon;
                ew[14][0] = t0 ^= u;
                ew[14][1] = t1 ^= t0;
                ew[14][2] = t2 ^= t1;
                ew[14][3] = t3 ^= t2;
                break;
            }
            default: {
                return null;
            }
        }
        if (!forDecryption) {
            return new AesKey(rounds, ew, null);
        }
        if (!forEncryption) {
            for (int j = 1; j < rounds; ++j) {
                ew[j][0] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][0]);
                ew[j][1] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][1]);
                ew[j][2] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][2]);
                ew[j][3] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][3]);
            }
            return new AesKey(rounds, null, ew);
        }
        int[][] dw = new int[rounds + 1][4];
        dw[0][0] = ew[0][0];
        dw[0][1] = ew[0][1];
        dw[0][2] = ew[0][2];
        dw[0][3] = ew[0][3];
        dw[rounds][0] = ew[rounds][0];
        dw[rounds][1] = ew[rounds][1];
        dw[rounds][2] = ew[rounds][2];
        dw[rounds][3] = ew[rounds][3];
        for (int j = 1; j < rounds; ++j) {
            dw[j][0] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][0]);
            dw[j][1] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][1]);
            dw[j][2] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][2]);
            dw[j][3] = EncryptionAesFastEngineGeneral_NonJava.inv_mcol(ew[j][3]);
        }
        return new AesKey(rounds, ew, dw);
    }

    public void loadIv(byte[] bytes) {
        this.unpackBlockStore1(bytes, 0);
    }

    public void processBlockEncryption(byte[] in, int inOff, byte[] out, int outOff) {
        this.unpackBlock(in, inOff);
        this.xorBlockByBlockStore1();
        this.encryptBlock();
        this.putBlockInBlockStore1();
        this.packBlock(out, outOff);
    }

    public void processBlockDecryption(byte[] in, int inOff, byte[] out, int outOff) {
        this.unpackBlock(in, inOff);
        this.putBlockInBlockStore2();
        this.decryptBlock();
        this.xorBlockByBlockStore1();
        this.putBlockStore2InBlockStore1();
        this.packBlock(out, outOff);
    }

    private void unpackBlock(byte[] bytes, int off) {
        this.C0 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off);
        this.C1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 4);
        this.C2 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 8);
        this.C3 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 12);
    }

    private void unpackBlockStore1(byte[] bytes, int off) {
        this.C0store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off);
        this.C1store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 4);
        this.C2store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 8);
        this.C3store1 = EncryptionAesFastEngineGeneral_NonJava.littleEndianToInt(bytes, off + 12);
    }

    private void packBlock(byte[] bytes, int off) {
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C0, bytes, off);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C1, bytes, off + 4);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C2, bytes, off + 8);
        EncryptionAesFastEngineGeneral_NonJava.intToLittleEndian(this.C3, bytes, off + 12);
    }

    private void putBlockInBlockStore1() {
        this.C0store1 = this.C0;
        this.C1store1 = this.C1;
        this.C2store1 = this.C2;
        this.C3store1 = this.C3;
    }

    private void putBlockInBlockStore2() {
        this.C0store2 = this.C0;
        this.C1store2 = this.C1;
        this.C2store2 = this.C2;
        this.C3store2 = this.C3;
    }

    private void putBlockStore2InBlockStore1() {
        this.C0store1 = this.C0store2;
        this.C1store1 = this.C1store2;
        this.C2store1 = this.C2store2;
        this.C3store1 = this.C3store2;
    }

    private void xorBlockByBlockStore1() {
        this.C0 ^= this.C0store1;
        this.C1 ^= this.C1store1;
        this.C2 ^= this.C2store1;
        this.C3 ^= this.C3store1;
    }

    private void encryptBlock() {
        int r2;
        int r1;
        int r0;
        int i3;
        int i2;
        int i1;
        int i0;
        int r;
        int t0 = this.C0 ^ this.EW[0][0];
        int t1 = this.C1 ^ this.EW[0][1];
        int t2 = this.C2 ^ this.EW[0][2];
        int r3 = this.C3 ^ this.EW[0][3];
        for (r = 1; r < this.ROUNDS - 1; ++r) {
            i0 = t0;
            i1 = EncryptionAesFastEngine_NonJava.s(t1, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t2, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
            r0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][0];
            i0 = t1;
            i1 = EncryptionAesFastEngine_NonJava.s(t2, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t0, 24);
            r1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][1];
            i0 = t2;
            i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t0, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t1, 24);
            r2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][2];
            i0 = r3;
            i1 = EncryptionAesFastEngine_NonJava.s(t0, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t1, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t2, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][3];
            i0 = r0;
            i1 = EncryptionAesFastEngine_NonJava.s(r1, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r2, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
            t0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[++r][0];
            i0 = r1;
            i1 = EncryptionAesFastEngine_NonJava.s(r2, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r0, 24);
            t1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][1];
            i0 = r2;
            i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r0, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r1, 24);
            t2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][2];
            i0 = r3;
            i1 = EncryptionAesFastEngine_NonJava.s(r0, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r1, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r2, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][3];
        }
        i0 = t0;
        i1 = EncryptionAesFastEngine_NonJava.s(t1, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t2, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
        r0 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][0];
        i0 = t1;
        i1 = EncryptionAesFastEngine_NonJava.s(t2, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t0, 24);
        r1 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][1];
        i0 = t2;
        i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t0, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t1, 24);
        r2 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][2];
        i0 = r3;
        i1 = EncryptionAesFastEngine_NonJava.s(t0, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t1, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t2, 24);
        r3 = EncryptionAesFastEngineGeneral_NonJava.T[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.T[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.T[768 + (i3 &= 0xFF)] ^ this.EW[r][3];
        ++r;
        i0 = r0;
        i1 = EncryptionAesFastEngine_NonJava.s(r1, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r2, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C0 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[r][0];
        i0 = r1;
        i1 = EncryptionAesFastEngine_NonJava.s(r2, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r0, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C1 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[r][1];
        i0 = r2;
        i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r0, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r1, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C2 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[r][2];
        i0 = r3;
        i1 = EncryptionAesFastEngine_NonJava.s(r0, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r1, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r2, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.S[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.S[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.S[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.S[i3 & 0xFF] & 0xFF;
        this.C3 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.EW[r][3];
    }

    private void decryptBlock() {
        int r2;
        int r1;
        int r0;
        int i3;
        int i2;
        int i1;
        int i0;
        int t0 = this.C0 ^ this.DW[this.ROUNDS][0];
        int t1 = this.C1 ^ this.DW[this.ROUNDS][1];
        int t2 = this.C2 ^ this.DW[this.ROUNDS][2];
        int r3 = this.C3 ^ this.DW[this.ROUNDS][3];
        for (int r = this.ROUNDS - 1; r > 1; --r) {
            i0 = t0;
            i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t2, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t1, 24);
            r0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][0];
            i0 = t1;
            i1 = EncryptionAesFastEngine_NonJava.s(t0, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t2, 24);
            r1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][1];
            i0 = t2;
            i1 = EncryptionAesFastEngine_NonJava.s(t1, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t0, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
            r2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][2];
            i0 = r3;
            i1 = EncryptionAesFastEngine_NonJava.s(t2, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(t1, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(t0, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][3];
            i0 = r0;
            i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r2, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r1, 24);
            t0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[--r][0];
            i0 = r1;
            i1 = EncryptionAesFastEngine_NonJava.s(r0, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r2, 24);
            t1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][1];
            i0 = r2;
            i1 = EncryptionAesFastEngine_NonJava.s(r1, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r0, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
            t2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][2];
            i0 = r3;
            i1 = EncryptionAesFastEngine_NonJava.s(r2, 8);
            i2 = EncryptionAesFastEngine_NonJava.s(r1, 16);
            i3 = EncryptionAesFastEngine_NonJava.s(r0, 24);
            r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[r][3];
        }
        i0 = t0;
        i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t2, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t1, 24);
        r0 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[1][0];
        i0 = t1;
        i1 = EncryptionAesFastEngine_NonJava.s(t0, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t2, 24);
        r1 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[1][1];
        i0 = t2;
        i1 = EncryptionAesFastEngine_NonJava.s(t1, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t0, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
        r2 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[1][2];
        i0 = r3;
        i1 = EncryptionAesFastEngine_NonJava.s(t2, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(t1, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(t0, 24);
        r3 = EncryptionAesFastEngineGeneral_NonJava.Tinv[i0 &= 0xFF] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[256 + (i1 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[512 + (i2 &= 0xFF)] ^ EncryptionAesFastEngineGeneral_NonJava.Tinv[768 + (i3 &= 0xFF)] ^ this.DW[1][3];
        i0 = r0;
        i1 = EncryptionAesFastEngine_NonJava.s(r3, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r2, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r1, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C0 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[0][0];
        i0 = r1;
        i1 = EncryptionAesFastEngine_NonJava.s(r0, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r3, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r2, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C1 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[0][1];
        i0 = r2;
        i1 = EncryptionAesFastEngine_NonJava.s(r1, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r0, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r3, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C2 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[0][2];
        i0 = r3;
        i1 = EncryptionAesFastEngine_NonJava.s(r2, 8);
        i2 = EncryptionAesFastEngine_NonJava.s(r1, 16);
        i3 = EncryptionAesFastEngine_NonJava.s(r0, 24);
        i0 = EncryptionAesFastEngineGeneral_NonJava.Si[i0 & 0xFF] & 0xFF;
        i1 = EncryptionAesFastEngineGeneral_NonJava.Si[i1 & 0xFF] & 0xFF;
        i2 = EncryptionAesFastEngineGeneral_NonJava.Si[i2 & 0xFF] & 0xFF;
        i3 = EncryptionAesFastEngineGeneral_NonJava.Si[i3 & 0xFF] & 0xFF;
        this.C3 = i0 ^ i1 << 8 ^ i2 << 16 ^ i3 << 24 ^ this.DW[0][3];
    }
}

