/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.jawnae.pyronet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroServer;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroSelectorListener;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroServerListener;

public class PyroSelector {
    public static final boolean DO_NOT_CHECK_NETWORK_THREAD = false;
    public static final int BUFFER_SIZE = 524288;
    private Thread networkThread;
    private final Selector nioSelector;
    public final ByteBuffer networkBuffer;
    private final PyroSelectorListener listener;
    private SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();

    public PyroSelector() {
        this(null);
    }

    public PyroSelector(PyroSelectorListener listener) {
        this.listener = listener;
        this.networkBuffer = ByteBuffer.allocateDirect(524288);
        try {
            this.nioSelector = Selector.open();
        }
        catch (IOException exc) {
            throw new PyroException("Failed to open a selector?!", exc);
        }
        this.networkThread = Thread.currentThread();
    }

    public ByteBuffer malloc(byte[] array) {
        ByteBuffer copy = ByteBuffer.allocate(array.length);
        copy.put(array);
        copy.flip();
        return copy;
    }

    public ByteBuffer copy(ByteBuffer buffer) {
        int pos = buffer.position();
        ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
        copy.put(buffer);
        buffer.position(pos);
        copy.flip();
        return copy;
    }

    public final boolean isNetworkThread() {
        return this.networkThread == Thread.currentThread();
    }

    public final Thread networkThread() {
        return this.networkThread;
    }

    public final void checkThread() {
        if (!this.isNetworkThread()) {
            throw new PyroException("call from outside the network-thread, you must schedule tasks");
        }
    }

    public PyroServer listen(InetSocketAddress end, int backlog, PyroServerListener listener) throws IOException {
        try {
            return new PyroServer(this, this.nioSelector, end, backlog, listener);
        }
        catch (IOException exc) {
            if (this.listener == null) {
                throw exc;
            }
            this.listener.serverBindFailed(exc);
            return null;
        }
    }

    public PyroServer listen(InetSocketAddress end, PyroServerListener listener) throws IOException {
        return this.listen(end, 50, listener);
    }

    public PyroServer listen(int port, PyroServerListener listener) throws IOException {
        return this.listen(new InetSocketAddress(InetAddress.getLocalHost(), port), listener);
    }

    public PyroServer listen(int port, int backlog, PyroServerListener listener) throws IOException {
        return this.listen(new InetSocketAddress(InetAddress.getLocalHost(), port), backlog, listener);
    }

    public PyroServer listen(boolean acceptExternalConnections, int port, PyroServerListener listener) throws IOException {
        return this.listen(new InetSocketAddress(acceptExternalConnections ? null : InetAddress.getLoopbackAddress(), port), listener);
    }

    public PyroServer listen(boolean acceptExternalConnections, int port, int backlog, PyroServerListener listener) throws IOException {
        return this.listen(new InetSocketAddress(acceptExternalConnections ? null : InetAddress.getLoopbackAddress(), port), backlog, listener);
    }

    public PyroClient connect(InetSocketAddress host, PyroClientListener listener) throws IOException {
        return this.connect(host, null, listener);
    }

    public PyroClient connect(InetSocketAddress host, InetSocketAddress bind, PyroClientListener listener) throws IOException {
        try {
            return new PyroClient(this, bind, host, listener);
        }
        catch (IOException exc) {
            if (this.listener == null) {
                throw exc;
            }
            this.listener.clientBindFailed(exc);
            return null;
        }
    }

    public void select(long eventTimeout) {
        this.executePendingTasks();
        this.performNioSelect(eventTimeout);
        this.handleSelectedKeys();
        this.executePendingTasks();
    }

    private void executePendingTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            if (this.listener != null) {
                this.listener.executingTask(task);
            }
            try {
                task.run();
            }
            catch (Exception cause) {
                if (this.listener != null) {
                    this.listener.taskCrashed(task, cause);
                    continue;
                }
                cause.printStackTrace();
            }
        }
    }

    private final void performNioSelect(long timeout) {
        int selected;
        try {
            selected = this.nioSelector.select(timeout);
        }
        catch (IOException exc) {
            if (this.listener != null) {
                this.listener.selectFailure(exc);
            } else {
                exc.printStackTrace();
            }
            return;
        }
        if (this.listener != null) {
            this.listener.selectedKeys(selected);
        }
    }

    private final void handleSelectedKeys() {
        Iterator<SelectionKey> keys = this.nioSelector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (key.channel() instanceof ServerSocketChannel) {
                PyroServer server = (PyroServer)key.attachment();
                if (this.listener != null) {
                    this.listener.serverSelected(server);
                }
                server.onInterestOp();
            }
            if (!(key.channel() instanceof SocketChannel)) continue;
            PyroClient client = (PyroClient)key.attachment();
            if (this.listener != null) {
                this.listener.clientSelected(client, key.readyOps());
            }
            client.onInterestOp();
        }
    }

    public void spawnNetworkThread(String name, long eventTimeout) {
        this.networkThread = null;
        new Thread(() -> {
            this.networkThread = Thread.currentThread();
            try {
                while (true) {
                    this.select(eventTimeout);
                }
            }
            catch (Exception exc) {
                throw new IllegalStateException(exc);
            }
        }, name).start();
    }

    public void scheduleTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.tasks.put(task);
        this.wakeup();
    }

    public void wakeup() {
        this.nioSelector.wakeup();
    }

    final SelectionKey register(SelectableChannel channel, int ops) throws IOException {
        return channel.register(this.nioSelector, ops);
    }

    final boolean adjustInterestOp(SelectionKey key, int op, boolean state) {
        this.checkThread();
        try {
            boolean changed;
            int ops = key.interestOps();
            boolean bl = changed = state != ((ops & op) == op);
            if (changed) {
                key.interestOps(state ? ops | op : ops & ~op);
            }
            return changed;
        }
        catch (CancelledKeyException exc) {
            return false;
        }
    }
}

