/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import lowentry.ue4.classes.sockets.SimpleSocketClient;
import lowentry.ue4.classes.sockets.SimpleSocketServer;
import lowentry.ue4.classes.sockets.simplification.SimpleSocketServerMain;
import lowentry.ue4.classes.sockets.simplification.SimpleSocketServerMainListener;
import lowentry.ue4.library.LowEntry;

public class ExampleSocket8
extends SimpleSocketServerMainListener {
    public static void main(String[] args) throws Throwable {
        SimpleSocketServer.setDebuggingEnabled();
        SimpleSocketServerMain.run(new ExampleSocket8(), 7780);
    }

    @Override
    public void hasStarted() {
        System.out.println("Server listening: " + this);
    }

    @Override
    public void beforeGracefulShutdown() {
        System.out.println("Server is gracefully stopping...");
    }

    @Override
    public long getMaxTimeMsForGracefulShutdown() {
        return LowEntry.Millis.MINUTES(10L);
    }

    @Override
    public void hasStopped() {
        System.out.println("Server stopped");
    }

    @Override
    public void serverErrored(Exception e) {
        System.out.println(LowEntry.getStackTrace(e));
    }

    @Override
    public void clientErrored(Exception e) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            System.out.println(LowEntry.getStackTrace(e));
        }
    }

    @Override
    public void clientConnected(SimpleSocketClient client) {
    }

    @Override
    public void clientDisconnected(SimpleSocketClient client) {
    }

    @Override
    public long getTimeMsBeforeNextTick() {
        return 300000L;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean canReceivePacket(SimpleSocketClient client, int bytes) {
        return bytes >= 1 && bytes <= 5000;
    }

    @Override
    public void receivedPacket(SimpleSocketClient client, byte[] bytes) {
        if (SimpleSocketServer.IS_DEBUGGING) {
            SimpleSocketServer.DEBUGGING_PRINTSTREAM.println(" > " + client + " has send message: " + LowEntry.bytesToHex(bytes));
        }
    }
}

