/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import java.nio.ByteBuffer;
import lowentry.ue4.classes.sockets.LatentResponse;
import lowentry.ue4.classes.sockets.SocketClient;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.classes.sockets.SocketServerListener;
import lowentry.ue4.library.LowEntry;

public class ExampleSocket5 {
    public static void main(String[] args) throws Throwable {
        SocketServerListener listener = new SocketServerListener(){

            @Override
            public void clientConnected(SocketServer server, SocketClient client) {
            }

            @Override
            public void clientDisconnected(SocketServer server, SocketClient client) {
            }

            @Override
            public void receivedConnectionValidation(SocketServer server, SocketClient client) {
            }

            @Override
            public boolean startReceivingUnreliableMessage(SocketServer server, SocketClient client, int bytes) {
                return false;
            }

            @Override
            public void receivedUnreliableMessage(SocketServer server, SocketClient client, ByteBuffer bytes) {
            }

            @Override
            public boolean startReceivingMessage(SocketServer server, SocketClient client, int bytes) {
                return false;
            }

            @Override
            public void receivedMessage(SocketServer server, SocketClient client, byte[] bytes) {
            }

            @Override
            public boolean startReceivingFunctionCall(SocketServer server, SocketClient client, int bytes) {
                return false;
            }

            @Override
            public byte[] receivedFunctionCall(SocketServer server, SocketClient client, byte[] bytes) {
                return null;
            }

            @Override
            public boolean startReceivingLatentFunctionCall(SocketServer server, SocketClient client, int bytes) {
                return true;
            }

            @Override
            public void receivedLatentFunctionCall(SocketServer server, SocketClient client, byte[] bytes, LatentResponse response) {
                System.out.println("received a latent function call: \"" + LowEntry.bytesToStringUtf8(bytes) + "\"");
                response.setOnCanceled(() -> System.out.println("the latent function call has been canceled!"));
                new Thread(() -> {
                    LowEntry.sleep(5000L);
                    response.done(LowEntry.stringToBytesUtf8("success!"));
                    if (response.isDone()) {
                        System.out.println("the latent function call has been completed!");
                    } else {
                        System.out.println("the latent function call has already been canceled!");
                    }
                }).start();
            }
        };
        SocketServer server = new SocketServer(false, 7780, 7880, listener);
        System.out.println("Listening: " + server);
        while (true) {
            server.listen();
        }
    }
}

