/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.examples;

import java.util.ArrayList;
import java.util.Iterator;
import lowentry.ue4.classes.sockets.SocketConnection;
import lowentry.ue4.classes.sockets.SocketConnectionListener;
import lowentry.ue4.library.LowEntry;

public class ExampleSocket4 {
    public static void main(String[] args) throws Throwable {
        byte[] packet = LowEntry.mergeBytes(LowEntry.integerToBytes(301), LowEntry.integerToBytes(5));
        SocketConnectionListener listener = new SocketConnectionListener(){

            @Override
            public void connected(SocketConnection connection) {
                System.out.println("Connected: " + connection);
            }

            @Override
            public void disconnected(SocketConnection connection) {
                System.out.println("Disconnected: " + connection);
            }

            @Override
            public void receivedUnreliableMessage(SocketConnection connection, byte[] bytes) {
            }

            @Override
            public void receivedMessage(SocketConnection connection, byte[] bytes) {
            }
        };
        ArrayList<SocketConnection> connections = new ArrayList<SocketConnection>();
        for (int i = 1; i <= 5000; ++i) {
            try {
                SocketConnection connection = new SocketConnection("localhost", 7780, 7880, listener);
                if (connection.connect()) {
                    connections.add(connection);
                } else {
                    System.out.println("Failed to connect");
                }
            }
            catch (Exception e) {
                System.out.println("Failed to connect");
            }
            LowEntry.sleep(10L);
            if (i % 50 != 0) continue;
            System.out.println(connections.size() + " connected");
        }
        SocketConnection.FunctionCallListener functionCallListener = new SocketConnection.FunctionCallListener(){

            @Override
            public void receivedResponse(SocketConnection connection, byte[] bytes) {
            }

            @Override
            public void failed(SocketConnection connection) {
            }
        };
        int loops = 0;
        while (connections.size() > 0) {
            System.out.println("[" + ++loops + "] " + connections.size() + " connected");
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                SocketConnection connection = (SocketConnection)iterator.next();
                if (connection.isConnected()) {
                    connection.sendFunctionCall(packet, functionCallListener);
                    connection.listen(1L);
                    continue;
                }
                iterator.remove();
            }
        }
    }
}

