/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal.rsa;

import lowentry.ue4.classes.internal.rsa.RsaBigInteger;
import lowentry.ue4.classes.internal.rsa.RsaMutableBigInteger;

class RsaBitSieve {
    private long[] bits;
    private int length;
    private static final RsaBitSieve smallSieve = new RsaBitSieve();

    private RsaBitSieve() {
        this.length = 9600;
        this.bits = new long[RsaBitSieve.unitIndex(this.length - 1) + 1];
        this.set(0);
        int nextIndex = 1;
        int nextPrime = 3;
        do {
            this.sieveSingle(this.length, nextIndex + nextPrime, nextPrime);
            nextIndex = this.sieveSearch(this.length, nextIndex + 1);
            nextPrime = 2 * nextIndex + 1;
        } while (nextIndex > 0 && nextPrime < this.length);
    }

    public RsaBitSieve(RsaBigInteger base, int searchLen) {
        if (base == null) {
            this.bits = new long[0];
            this.length = 0;
            return;
        }
        this.bits = new long[RsaBitSieve.unitIndex(searchLen - 1) + 1];
        this.length = searchLen;
        int start = 0;
        int step = smallSieve.sieveSearch(RsaBitSieve.smallSieve.length, start);
        int convertedStep = step * 2 + 1;
        RsaMutableBigInteger b = new RsaMutableBigInteger(base);
        RsaMutableBigInteger q = new RsaMutableBigInteger();
        do {
            start = b.divideOneWord(convertedStep, q);
            if ((start = convertedStep - start) % 2 == 0) {
                start += convertedStep;
            }
            this.sieveSingle(searchLen, (start - 1) / 2, convertedStep);
            step = smallSieve.sieveSearch(RsaBitSieve.smallSieve.length, step + 1);
            convertedStep = step * 2 + 1;
        } while (step > 0);
    }

    private static int si(int a, int b) {
        return a >>> b;
    }

    private static long sl(long a, int b) {
        return a >>> b;
    }

    private static int unitIndex(int bitIndex) {
        return RsaBitSieve.si(bitIndex, 6);
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private boolean get(int bitIndex) {
        int unitIndex = RsaBitSieve.unitIndex(bitIndex);
        if (unitIndex >= this.bits.length) {
            return false;
        }
        return (this.bits[unitIndex] & RsaBitSieve.bit(bitIndex)) != 0L;
    }

    private void set(int bitIndex) {
        int unitIndex = RsaBitSieve.unitIndex(bitIndex);
        if (unitIndex >= this.bits.length) {
            return;
        }
        int n = unitIndex;
        this.bits[n] = this.bits[n] | RsaBitSieve.bit(bitIndex);
    }

    private int sieveSearch(int limit, int start) {
        if (start >= limit) {
            return -1;
        }
        int index = start;
        do {
            if (this.get(index)) continue;
            return index;
        } while (++index < limit - 1);
        return -1;
    }

    private void sieveSingle(int limit, int start, int step) {
        if (step <= 0) {
            return;
        }
        while (start < limit) {
            this.set(start);
            start += step;
        }
    }

    public RsaBigInteger retrieve(RsaBigInteger initValue, int certainty) {
        if (initValue == null) {
            return null;
        }
        long offset = 1L;
        for (int i = 0; i < this.bits.length; ++i) {
            long nextLong = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            for (int j = 0; j < 64; ++j) {
                if ((nextLong & 1L) == 1L) {
                    RsaBigInteger candidate = initValue.add(RsaBigInteger.valueOf(offset));
                    if (candidate == null) {
                        return null;
                    }
                    if (candidate.primeToCertainty(certainty)) {
                        return candidate;
                    }
                }
                nextLong = RsaBitSieve.sl(nextLong, 1);
                offset += 2L;
            }
        }
        return null;
    }
}

