/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes;

import java.nio.ByteBuffer;
import java.util.Collection;
import lowentry.ue4.library.LowEntry;

public abstract class BitDataWriter {
    protected static final byte[] mask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    protected byte currentByte = 0;
    protected int currentBytePosition = 0;

    protected abstract byte[] getBytesImplementation();

    protected abstract byte[] getBytesImplementation(byte var1);

    protected ByteBuffer getByteBufferImplementation() {
        return ByteBuffer.wrap(this.getBytesImplementation());
    }

    protected ByteBuffer getByteBufferImplementation(byte addByteToEnd) {
        return ByteBuffer.wrap(this.getBytesImplementation(addByteToEnd));
    }

    protected abstract void resetImplementation();

    protected abstract void addRawByteImplementation(byte var1);

    protected abstract void addRawBytesImplementation(byte[] var1);

    protected abstract void addingUnsafeImplementation(int var1);

    protected abstract void addRawByteUnsafeImplementation(byte var1);

    protected abstract void addRawBytesUnsafeImplementation(byte[] var1);

    public byte[] getBytes() {
        if (this.currentBytePosition == 0) {
            return this.getBytesImplementation();
        }
        return this.getBytesImplementation(this.currentByte);
    }

    public ByteBuffer getByteBuffer() {
        if (this.currentBytePosition == 0) {
            return this.getByteBufferImplementation();
        }
        return this.getByteBufferImplementation(this.currentByte);
    }

    public BitDataWriter reset() {
        this.resetImplementation();
        this.currentByte = 0;
        this.currentBytePosition = 0;
        return this;
    }

    protected void addRawBit(boolean bit) {
        if (bit) {
            this.currentByte = (byte)(this.currentByte | 1 << this.currentBytePosition);
        }
        if (this.currentBytePosition == 7) {
            this.addRawByteImplementation(this.currentByte);
            this.currentByte = 0;
            this.currentBytePosition = 0;
        } else {
            ++this.currentBytePosition;
        }
    }

    protected void addRawByte(byte b) {
        if (this.currentBytePosition == 0) {
            this.addRawByteImplementation(b);
        } else {
            this.currentByte = (byte)(this.currentByte | b << this.currentBytePosition);
            this.addRawByteImplementation(this.currentByte);
            this.currentByte = (byte)(b >> 8 - this.currentBytePosition & mask[this.currentBytePosition]);
        }
    }

    protected void addPartialRawByte(byte b, int bits) {
        if (bits == 0) {
            return;
        }
        if (bits >= 8 || bits <= -8) {
            this.addRawByte(b);
            return;
        }
        if (bits < 0) {
            bits = -bits;
            b = (byte)(b >> 8 - bits);
        }
        b = (byte)(b & mask[bits]);
        this.currentByte = (byte)(this.currentByte | b << this.currentBytePosition);
        this.currentBytePosition += bits;
        if (this.currentBytePosition >= 8) {
            this.addRawByteImplementation(this.currentByte);
            this.currentBytePosition -= 8;
            this.currentByte = this.currentBytePosition == 0 ? (byte)0 : (byte)(b >> bits - this.currentBytePosition);
        }
    }

    protected void addRawBytes(byte[] value) {
        if (value == null) {
            return;
        }
        if (this.currentBytePosition == 0) {
            this.addRawBytesImplementation(value);
        } else {
            this.addingUnsafe(value.length);
            for (byte b : value) {
                this.addRawByteUnsafe(b);
            }
        }
    }

    protected void addingUnsafe(int count) {
        this.addingUnsafeImplementation(count);
    }

    protected void addRawBitUnsafe(boolean bit) {
        if (bit) {
            this.currentByte = (byte)(this.currentByte | 1 << this.currentBytePosition);
        }
        if (this.currentBytePosition == 7) {
            this.addRawByteUnsafeImplementation(this.currentByte);
            this.currentByte = 0;
            this.currentBytePosition = 0;
        } else {
            ++this.currentBytePosition;
        }
    }

    protected void addRawByteUnsafe(byte b) {
        if (this.currentBytePosition == 0) {
            this.addRawByteUnsafeImplementation(b);
        } else {
            this.currentByte = (byte)(this.currentByte | b << this.currentBytePosition);
            this.addRawByteUnsafeImplementation(this.currentByte);
            this.currentByte = (byte)(b >> 8 - this.currentBytePosition & mask[this.currentBytePosition]);
        }
    }

    protected void addPartialRawByteUnsafe(byte b, int bits) {
        if (bits == 0) {
            return;
        }
        if (bits >= 8 || bits <= -8) {
            this.addRawByteUnsafe(b);
            return;
        }
        if (bits < 0) {
            bits = -bits;
            b = (byte)(b >> 8 - bits);
        }
        b = (byte)(b & mask[bits]);
        this.currentByte = (byte)(this.currentByte | b << this.currentBytePosition);
        this.currentBytePosition += bits;
        if (this.currentBytePosition >= 8) {
            this.addRawByteUnsafeImplementation(this.currentByte);
            this.currentBytePosition -= 8;
            this.currentByte = this.currentBytePosition == 0 ? (byte)0 : (byte)(b >> bits - this.currentBytePosition);
        }
    }

    protected void addRawBytesUnsafe(byte[] value) {
        if (value == null) {
            return;
        }
        if (this.currentBytePosition == 0) {
            this.addRawBytesUnsafeImplementation(value);
        } else {
            for (byte b : value) {
                this.addRawByteUnsafe(b);
            }
        }
    }

    protected void addUinteger(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 128) {
            this.addRawByte((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
    }

    protected void addUintegerUnsafe(int value) {
        if (value <= 0) {
            this.addRawByteUnsafe((byte)0);
        } else if (value < 128) {
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
    }

    public BitDataWriter add(byte value) {
        this.addByte(value);
        return this;
    }

    public BitDataWriter add(int value) {
        this.addInteger(value);
        return this;
    }

    public BitDataWriter add(long value) {
        this.addLong(value);
        return this;
    }

    public BitDataWriter add(float value) {
        this.addFloat(value);
        return this;
    }

    public BitDataWriter add(double value) {
        this.addDouble(value);
        return this;
    }

    public BitDataWriter add(boolean value) {
        this.addBoolean(value);
        return this;
    }

    public BitDataWriter add(String value) {
        this.addStringUtf8(value);
        return this;
    }

    public BitDataWriter add(Byte value) {
        this.addByte(value);
        return this;
    }

    public BitDataWriter add(Integer value) {
        this.addInteger(value);
        return this;
    }

    public BitDataWriter add(Long value) {
        this.addLong(value);
        return this;
    }

    public BitDataWriter add(Float value) {
        this.addFloat(value);
        return this;
    }

    public BitDataWriter add(Double value) {
        this.addDouble(value);
        return this;
    }

    public BitDataWriter add(Boolean value) {
        this.addBoolean(value);
        return this;
    }

    public BitDataWriter add(byte[] value) {
        this.addByteArray(value);
        return this;
    }

    public BitDataWriter add(int[] value) {
        this.addIntegerArray(value);
        return this;
    }

    public BitDataWriter add(long[] value) {
        this.addLongArray(value);
        return this;
    }

    public BitDataWriter add(float[] value) {
        this.addFloatArray(value);
        return this;
    }

    public BitDataWriter add(double[] value) {
        this.addDoubleArray(value);
        return this;
    }

    public BitDataWriter add(boolean[] value) {
        this.addBooleanArray(value);
        return this;
    }

    public BitDataWriter add(String[] value) {
        this.addStringUtf8Array(value);
        return this;
    }

    public BitDataWriter add(Byte[] value) {
        this.addByteArray(value);
        return this;
    }

    public BitDataWriter add(Integer[] value) {
        this.addIntegerArray(value);
        return this;
    }

    public BitDataWriter add(Long[] value) {
        this.addLongArray(value);
        return this;
    }

    public BitDataWriter add(Float[] value) {
        this.addFloatArray(value);
        return this;
    }

    public BitDataWriter add(Double[] value) {
        this.addDoubleArray(value);
        return this;
    }

    public BitDataWriter add(Boolean[] value) {
        this.addBooleanArray(value);
        return this;
    }

    public BitDataWriter add(Collection<?> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        for (Byte by : value) {
            if (by == null) continue;
            if (by instanceof Byte) {
                this.addByteArray(value);
            } else if (by instanceof Integer) {
                this.addIntegerArray(value);
            } else if (by instanceof Long) {
                this.addLongArray(value);
            } else if (by instanceof Float) {
                this.addFloatArray(value);
            } else if (by instanceof Double) {
                this.addDoubleArray(value);
            } else if (by instanceof Boolean) {
                this.addBooleanArray(value);
            } else if (by instanceof String) {
                this.addStringUtf8Array(value);
            } else {
                this.addUinteger(0);
            }
            return this;
        }
        this.addUinteger(0);
        return this;
    }

    public BitDataWriter addBit(boolean value) {
        this.addRawBit(value);
        return this;
    }

    public BitDataWriter addByteLeastSignificantBits(byte value, int bitcount) {
        if (bitcount > 0) {
            this.addPartialRawByte(value, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteMostSignificantBits(byte value, int bitcount) {
        if (bitcount > 0) {
            this.addPartialRawByte(value, -bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerLeastSignificantBits(int value, int bitcount) {
        if (bitcount > 0) {
            if (bitcount >= 32) {
                this.addingUnsafe(4);
                this.addRawByteUnsafe((byte)value);
                this.addRawByteUnsafe((byte)(value >> 8));
                this.addRawByteUnsafe((byte)(value >> 16));
                this.addRawByteUnsafe((byte)(value >> 24));
            } else if (bitcount > 24) {
                this.addingUnsafe(4);
                this.addRawByteUnsafe((byte)value);
                this.addRawByteUnsafe((byte)(value >> 8));
                this.addRawByteUnsafe((byte)(value >> 16));
                this.addPartialRawByteUnsafe((byte)(value >> 24), bitcount - 24);
            } else if (bitcount > 16) {
                this.addingUnsafe(3);
                this.addRawByteUnsafe((byte)value);
                this.addRawByteUnsafe((byte)(value >> 8));
                this.addPartialRawByteUnsafe((byte)(value >> 16), bitcount - 16);
            } else if (bitcount > 8) {
                this.addingUnsafe(2);
                this.addRawByteUnsafe((byte)value);
                this.addPartialRawByteUnsafe((byte)(value >> 8), bitcount - 8);
            } else {
                this.addPartialRawByte((byte)value, bitcount);
            }
        }
        return this;
    }

    public BitDataWriter addIntegerMostSignificantBits(int value, int bitcount) {
        if (bitcount > 0) {
            if ((bitcount = -bitcount) <= -32) {
                this.addingUnsafe(4);
                this.addRawByteUnsafe((byte)value);
                this.addRawByteUnsafe((byte)(value >> 8));
                this.addRawByteUnsafe((byte)(value >> 16));
                this.addRawByteUnsafe((byte)(value >> 24));
            } else if (bitcount < -24) {
                this.addingUnsafe(4);
                this.addPartialRawByteUnsafe((byte)value, bitcount + 24);
                this.addRawByteUnsafe((byte)(value >> 8));
                this.addRawByteUnsafe((byte)(value >> 16));
                this.addRawByteUnsafe((byte)(value >> 24));
            } else if (bitcount < -16) {
                this.addingUnsafe(3);
                this.addPartialRawByteUnsafe((byte)(value >> 8), bitcount + 16);
                this.addRawByteUnsafe((byte)(value >> 16));
                this.addRawByteUnsafe((byte)(value >> 24));
            } else if (bitcount < -8) {
                this.addingUnsafe(2);
                this.addPartialRawByteUnsafe((byte)(value >> 16), bitcount + 8);
                this.addRawByteUnsafe((byte)(value >> 24));
            } else {
                this.addPartialRawByte((byte)(value >> 24), bitcount);
            }
        }
        return this;
    }

    public BitDataWriter addByte(byte value) {
        this.addRawByte(value);
        return this;
    }

    public BitDataWriter addInteger(int value) {
        this.addingUnsafe(4);
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
        return this;
    }

    public BitDataWriter addPositiveInteger1(int value) {
        if (value <= 0) {
            this.addRawByte((byte)0);
        } else if (value < 128) {
            this.addRawByte((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger2(int value) {
        if (value <= 0) {
            this.addingUnsafe(2);
            this.addRawByteUnsafe((byte)0);
            this.addRawByteUnsafe((byte)0);
        } else if (value < 32768) {
            this.addingUnsafe(2);
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger3(int value) {
        if (value <= 0) {
            this.addingUnsafe(3);
            this.addRawByteUnsafe((byte)0);
            this.addRawByteUnsafe((byte)0);
            this.addRawByteUnsafe((byte)0);
        } else if (value < 0x800000) {
            this.addingUnsafe(3);
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        } else {
            this.addingUnsafe(4);
            this.addRawByteUnsafe((byte)(value >> 24 | 0x80));
            this.addRawByteUnsafe((byte)(value >> 16));
            this.addRawByteUnsafe((byte)(value >> 8));
            this.addRawByteUnsafe((byte)value);
        }
        return this;
    }

    public BitDataWriter addLong(long value) {
        this.addingUnsafe(8);
        this.addRawByteUnsafe((byte)(value >> 56));
        this.addRawByteUnsafe((byte)(value >> 48));
        this.addRawByteUnsafe((byte)(value >> 40));
        this.addRawByteUnsafe((byte)(value >> 32));
        this.addRawByteUnsafe((byte)(value >> 24));
        this.addRawByteUnsafe((byte)(value >> 16));
        this.addRawByteUnsafe((byte)(value >> 8));
        this.addRawByteUnsafe((byte)value);
        return this;
    }

    public BitDataWriter addFloat(float value) {
        this.addInteger(Float.floatToIntBits(value));
        return this;
    }

    public BitDataWriter addDouble(double value) {
        this.addLong(Double.doubleToLongBits(value));
        return this;
    }

    public BitDataWriter addBoolean(boolean value) {
        this.addRawBit(value);
        return this;
    }

    public BitDataWriter addStringUtf8(String value) {
        this.addByteArray(LowEntry.stringToBytesUtf8(value));
        return this;
    }

    public BitDataWriter addStringLatin1(String value) {
        this.addByteArray(LowEntry.stringToBytesLatin1(value));
        return this;
    }

    public BitDataWriter addBit(Boolean value) {
        if (value == null) {
            this.addBit(false);
        } else {
            this.addBit((boolean)value);
        }
        return this;
    }

    public BitDataWriter addByteLeastSignificantBits(Byte value, int bitcount) {
        if (value == null) {
            this.addByteLeastSignificantBits((byte)0, bitcount);
        } else {
            this.addByteLeastSignificantBits((byte)value, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteMostSignificantBits(Byte value, int bitcount) {
        if (value == null) {
            this.addByteMostSignificantBits((byte)0, bitcount);
        } else {
            this.addByteMostSignificantBits((byte)value, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerLeastSignificantBits(Integer value, int bitcount) {
        if (value == null) {
            this.addIntegerLeastSignificantBits(0, bitcount);
        } else {
            this.addIntegerLeastSignificantBits((int)value, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerMostSignificantBits(Integer value, int bitcount) {
        if (value == null) {
            this.addIntegerMostSignificantBits(0, bitcount);
        } else {
            this.addIntegerMostSignificantBits((int)value, bitcount);
        }
        return this;
    }

    public BitDataWriter addByte(Byte value) {
        if (value == null) {
            this.addByte((byte)0);
        } else {
            this.addByte((byte)value);
        }
        return this;
    }

    public BitDataWriter addInteger(Integer value) {
        if (value == null) {
            this.addInteger(0);
        } else {
            this.addInteger((int)value);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger1(Integer value) {
        if (value == null) {
            this.addPositiveInteger1(0);
        } else {
            this.addPositiveInteger1((int)value);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger2(Integer value) {
        if (value == null) {
            this.addPositiveInteger2(0);
        } else {
            this.addPositiveInteger2((int)value);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger3(Integer value) {
        if (value == null) {
            this.addPositiveInteger3(0);
        } else {
            this.addPositiveInteger3((int)value);
        }
        return this;
    }

    public BitDataWriter addLong(Long value) {
        if (value == null) {
            this.addLong(0L);
        } else {
            this.addLong((long)value);
        }
        return this;
    }

    public BitDataWriter addFloat(Float value) {
        if (value == null) {
            this.addFloat(0.0f);
        } else {
            this.addFloat(value.floatValue());
        }
        return this;
    }

    public BitDataWriter addDouble(Double value) {
        if (value == null) {
            this.addDouble(0.0);
        } else {
            this.addDouble((double)value);
        }
        return this;
    }

    public BitDataWriter addBoolean(Boolean value) {
        if (value == null) {
            this.addRawBit(false);
        } else {
            this.addRawBit(value);
        }
        return this;
    }

    public BitDataWriter addBitArray(boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (boolean v : value) {
            this.addBit(v);
        }
        return this;
    }

    public BitDataWriter addByteArrayLeastSignificantBits(byte[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        bitcount = Math.max(0, Math.min(8, bitcount));
        this.addUinteger(value.length);
        for (byte v : value) {
            this.addByteLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArrayMostSignificantBits(byte[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (byte v : value) {
            this.addByteMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayLeastSignificantBits(int[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addIntegerLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayMostSignificantBits(int[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addIntegerMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArray(byte[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        this.addRawBytes(value);
        return this;
    }

    public BitDataWriter addIntegerArray(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger1Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger2Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger3Array(int[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (int v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public BitDataWriter addLongArray(long[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public BitDataWriter addFloatArray(float[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public BitDataWriter addDoubleArray(double[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public BitDataWriter addBooleanArray(boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (boolean v : value) {
            this.addBoolean(v);
        }
        return this;
    }

    public BitDataWriter addStringUtf8Array(String[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (String v : value) {
            this.addStringUtf8(v);
        }
        return this;
    }

    public BitDataWriter addStringLatin1Array(String[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (String v : value) {
            this.addStringLatin1(v);
        }
        return this;
    }

    public BitDataWriter addBitArray(Boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Boolean v : value) {
            this.addBit(v);
        }
        return this;
    }

    public BitDataWriter addByteArrayLeastSignificantBits(Byte[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Byte v : value) {
            this.addByteLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArrayMostSignificantBits(Byte[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Byte v : value) {
            this.addByteMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayLeastSignificantBits(Integer[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addIntegerLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayMostSignificantBits(Integer[] value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addIntegerMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArray(Byte[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Byte v : value) {
            this.addByte(v);
        }
        return this;
    }

    public BitDataWriter addIntegerArray(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger1Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger2Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger3Array(Integer[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Integer v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public BitDataWriter addLongArray(Long[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public BitDataWriter addFloatArray(Float[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public BitDataWriter addDoubleArray(Double[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public BitDataWriter addBooleanArray(Boolean[] value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.length);
        for (Boolean v : value) {
            this.addBoolean(v);
        }
        return this;
    }

    public BitDataWriter addBitArray(Collection<Boolean> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Boolean v : value) {
            this.addBit(v);
        }
        return this;
    }

    public BitDataWriter addByteArrayLeastSignificantBits(Collection<Byte> value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Byte v : value) {
            this.addByteLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArrayMostSignificantBits(Collection<Byte> value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Byte v : value) {
            this.addByteMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayLeastSignificantBits(Collection<Integer> value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addIntegerLeastSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addIntegerArrayMostSignificantBits(Collection<Integer> value, int bitcount) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addIntegerMostSignificantBits(v, bitcount);
        }
        return this;
    }

    public BitDataWriter addByteArray(Collection<Byte> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Byte v : value) {
            this.addByte(v);
        }
        return this;
    }

    public BitDataWriter addIntegerArray(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addInteger(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger1Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger1(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger2Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger2(v);
        }
        return this;
    }

    public BitDataWriter addPositiveInteger3Array(Collection<Integer> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Integer v : value) {
            this.addPositiveInteger3(v);
        }
        return this;
    }

    public BitDataWriter addLongArray(Collection<Long> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Long v : value) {
            this.addLong(v);
        }
        return this;
    }

    public BitDataWriter addFloatArray(Collection<Float> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Float v : value) {
            this.addFloat(v);
        }
        return this;
    }

    public BitDataWriter addDoubleArray(Collection<Double> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Double v : value) {
            this.addDouble(v);
        }
        return this;
    }

    public BitDataWriter addBooleanArray(Collection<Boolean> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (Boolean v : value) {
            this.addBoolean(v);
        }
        return this;
    }

    public BitDataWriter addStringUtf8Array(Collection<String> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (String v : value) {
            this.addStringUtf8(v);
        }
        return this;
    }

    public BitDataWriter addStringLatin1Array(Collection<String> value) {
        if (value == null) {
            this.addUinteger(0);
            return this;
        }
        this.addUinteger(value.size());
        for (String v : value) {
            this.addStringLatin1(v);
        }
        return this;
    }
}

