/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.leafspace;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.comm.CommAdapter;
import com.spacenetwork.mcs.entites.comm.obj.PayloadPair;
import com.spacenetwork.mcs.entites.comm.obj.SNPacket;
import com.spacenetwork.mcs.services.EncryptionService;
import com.spacenetwork.mcs.services.SNCommService;
import fr.devnied.bitlib.BytesUtils;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.BiConsumer;
import javax.crypto.NoSuchPaddingException;
import javax.inject.Singleton;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@Singleton
public class LeafSpaceSandboxCommAdapter
extends CommAdapter<SNPacket> {
    private static final String BROKER_URL = "ssl://mqtt-sandbox.leaf.space:8883";
    private static final String USERNAME = "spacenetwork01";
    private static final String PASSWORD = "PfHZ2qTqp86Jklh5rrfXzMObNgPUcNRi";
    private MqttClient client;
    private final List<BiConsumer<String, byte[]>> downlinkListeners = new ArrayList<BiConsumer<String, byte[]>>();

    public void connect() {
        String clientId = "LeafSpaceClient-" + System.currentTimeMillis();
        try {
            this.client = new MqttClient(BROKER_URL, clientId, null);
        }
        catch (MqttException e) {
            throw new RuntimeException("Failed to initialize MQTT Client", e);
        }
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setAutomaticReconnect(true);
        options.setUserName(USERNAME);
        options.setPassword(PASSWORD.toCharArray());
        options.setSocketFactory(SSLSocketFactory.getDefault());
        this.client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                System.err.println("\u274c Connection lost: " + cause.getMessage());
            }

            public void messageArrived(String topic, MqttMessage message) {
                String sourceSatId = LeafSpaceSandboxCommAdapter.this.extractSatIdFromTopic(topic);
                byte[] payload = message.getPayload();
                System.out.println("\ud83d\udce9 Message received from SAT-" + sourceSatId + " on " + topic + " (" + payload.length + " bytes)");
                System.out.println("Payload: " + Arrays.toString(payload));
                ((SNCommService)SpaceSDK.inject(SNCommService.class)).routeIn(payload);
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        try {
            System.out.println("\ud83d\udd17 Connecting to LeafSpace MQTT broker...");
            this.client.connect(options);
            System.out.println("\u2705 Connected to ssl://mqtt-sandbox.leaf.space:8883");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String extractSatIdFromTopic(String topic) {
        return "10200";
    }

    public void disconnect() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
                System.out.println("\ud83d\udd0c Disconnected from broker.");
            }
            catch (MqttException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void read() {
    }

    public void write(SNPacket packet) {
        try {
            this.sendUplink(1, packet.getData());
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendUplink(int satId, byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, InterruptedException {
        if (this.client == null || !this.client.isConnected()) {
            System.err.println("\u274c Client not connected, cannot send uplink.");
            return;
        }
        int lsId = (Integer)SNCommService.idMaps.get(satId);
        PayloadPair pair = ((SNCommService)SpaceSDK.inject(SNCommService.class)).getSatPair(satId);
        if (pair != null) {
            try {
                byte[] finalPayload = ((EncryptionService)SpaceSDK.inject(EncryptionService.class)).encrypt(bytes, Base64.getEncoder().encodeToString(pair.getRxKey()));
                System.out.println("Payload Size: " + finalPayload.length);
                System.out.println("Encrypted packet:: " + BytesUtils.bytesToString((byte[])finalPayload));
                String topic = "loopback/spacenetwork01/uplink";
                MqttMessage message = new MqttMessage(finalPayload);
                message.setQos(1);
                try {
                    this.client.publish(topic, message);
                    System.out.println("Tx \u27a1\ufe0f Uplink sent to " + topic + " (" + bytes.length + " bytes)");
                }
                catch (MqttException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

