/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.ParallelFlux;
import reactor.util.annotation.Nullable;

final class ParallelLift<I, O>
extends ParallelFlux<O>
implements Scannable {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;
    final ParallelFlux<I> source;

    ParallelLift(ParallelFlux<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        return null;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return Scannable.super.stepName();
    }

    @Override
    protected void subscribe(CoreSubscriber<? super O>[] s2) {
        CoreSubscriber[] subscribers = new CoreSubscriber[this.parallelism()];
        for (int i = 0; i < subscribers.length; ++i) {
            subscribers[i] = Objects.requireNonNull(this.lifter.apply(this.source, s2[i]), "Lifted subscriber MUST NOT be null");
        }
        this.source.subscribe(subscribers);
    }
}

