/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxNameFuseable;
import reactor.core.publisher.InternalFluxOperator;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class FluxName<T>
extends InternalFluxOperator<T, T> {
    final String name;
    final Set<Tuple2<String, String>> tags;

    static <T> Flux<T> createOrAppend(Flux<T> source2, String name) {
        Objects.requireNonNull(name, "name");
        if (source2 instanceof FluxName) {
            FluxName s2 = (FluxName)source2;
            return new FluxName<T>(s2.source, name, s2.tags);
        }
        if (source2 instanceof FluxNameFuseable) {
            FluxNameFuseable s3 = (FluxNameFuseable)source2;
            return new FluxNameFuseable(s3.source, name, s3.tags);
        }
        if (source2 instanceof Fuseable) {
            return new FluxNameFuseable<T>(source2, name, null);
        }
        return new FluxName<T>(source2, name, null);
    }

    static <T> Flux<T> createOrAppend(Flux<T> source2, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Set<Tuple2<String, String>> tags = Collections.singleton(Tuples.of(tagName, tagValue));
        if (source2 instanceof FluxName) {
            FluxName s2 = (FluxName)source2;
            if (s2.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s2.tags);
            }
            return new FluxName<T>(s2.source, s2.name, tags);
        }
        if (source2 instanceof FluxNameFuseable) {
            FluxNameFuseable s3 = (FluxNameFuseable)source2;
            if (s3.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s3.tags);
            }
            return new FluxNameFuseable(s3.source, s3.name, tags);
        }
        if (source2 instanceof Fuseable) {
            return new FluxNameFuseable<T>(source2, null, tags);
        }
        return new FluxName<T>(source2, null, tags);
    }

    FluxName(Flux<? extends T> source2, @Nullable String name, @Nullable Set<Tuple2<String, String>> tags) {
        super(source2);
        this.name = name;
        this.tags = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tags != null) {
            return this.tags.stream();
        }
        return super.scanUnsafe(key);
    }
}

