/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.command;

import net.dartnode.mon.entites.net.HiveCommandMessage;
import net.dartnode.mon.entites.net.HiveReplyMessage;

public enum CommandFactory {
    ACK(true),
    NAK(false);

    protected HiveReplyMessage message;
    protected boolean success;

    private CommandFactory(boolean success) {
        this.success = success;
        this.message = new HiveReplyMessage();
    }

    private CommandFactory(boolean success, HiveCommandMessage commandMessage) {
        this.success = success;
        this.message = new HiveReplyMessage();
        this.message.id = commandMessage.id;
        this.message.to = commandMessage.to;
        this.message.cmd = "reply";
    }

    public CommandFactory set(String key, Object v) {
        this.message.data.put(key, v);
        return this;
    }

    public CommandFactory msg(String msg) {
        this.message.data.put("msg", msg);
        return this;
    }

    public CommandFactory attach(HiveCommandMessage commandMessage) {
        this.message.id = commandMessage.id;
        this.message.to = commandMessage.to;
        this.message.cmd = "reply";
        return this;
    }

    public HiveReplyMessage get() {
        return this.message;
    }
}

