/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.List;

public class ZAggregateArgs
implements CompositeArgument {
    private List<Double> weights;
    private Aggregate aggregate;

    public ZAggregateArgs weights(double ... weights) {
        LettuceAssert.notNull((Object)weights, "Weights must not be null");
        this.weights = new ArrayList<Double>(weights.length);
        for (double weight : weights) {
            this.weights.add(weight);
        }
        return this;
    }

    public ZAggregateArgs sum() {
        this.aggregate = Aggregate.SUM;
        return this;
    }

    public ZAggregateArgs min() {
        this.aggregate = Aggregate.MIN;
        return this;
    }

    public ZAggregateArgs max() {
        this.aggregate = Aggregate.MAX;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.weights != null && !this.weights.isEmpty()) {
            args2.add(CommandKeyword.WEIGHTS);
            for (double weight : this.weights) {
                args2.add(weight);
            }
        }
        if (this.aggregate != null) {
            args2.add(CommandKeyword.AGGREGATE);
            switch (this.aggregate) {
                case SUM: {
                    args2.add(CommandKeyword.SUM);
                    break;
                }
                case MIN: {
                    args2.add(CommandKeyword.MIN);
                    break;
                }
                case MAX: {
                    args2.add(CommandKeyword.MAX);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Aggregation " + (Object)((Object)this.aggregate) + " not supported");
                }
            }
        }
    }

    public static class Builder {
        Builder() {
        }

        public static ZAggregateArgs weights(double ... weights) {
            return new ZAggregateArgs().weights(weights);
        }

        public static ZAggregateArgs sum() {
            return new ZAggregateArgs().sum();
        }

        public static ZAggregateArgs min() {
            return new ZAggregateArgs().min();
        }

        public static ZAggregateArgs max() {
            return new ZAggregateArgs().max();
        }
    }

    private static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

