/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class GetExArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean persist = false;

    public GetExArgs ex(long timeout2) {
        this.ex = timeout2;
        return this;
    }

    public GetExArgs ex(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        this.ex = timeout2.toMillis() / 1000L;
        return this;
    }

    public GetExArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    public GetExArgs exAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.getTime() / 1000L);
    }

    public GetExArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.toEpochMilli() / 1000L);
    }

    public GetExArgs px(long timeout2) {
        this.px = timeout2;
        return this;
    }

    public GetExArgs px(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        this.px = timeout2.toMillis();
        return this;
    }

    public GetExArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    public GetExArgs pxAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.getTime());
    }

    public GetExArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.toEpochMilli());
    }

    public GetExArgs persist() {
        this.persist = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.ex != null) {
            args2.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args2.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args2.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args2.add("PXAT").add(this.pxAt);
        }
        if (this.persist) {
            args2.add(CommandType.PERSIST);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static GetExArgs ex(long timeout2) {
            return new GetExArgs().ex(timeout2);
        }

        public static GetExArgs ex(Duration timeout2) {
            return new GetExArgs().ex(timeout2);
        }

        public static GetExArgs exAt(long timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs exAt(Date timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs exAt(Instant timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs px(long timeout2) {
            return new GetExArgs().px(timeout2);
        }

        public static GetExArgs px(Duration timeout2) {
            return new GetExArgs().px(timeout2);
        }

        public static GetExArgs pxAt(long timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs pxAt(Date timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs pxAt(Instant timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs persist() {
            return new GetExArgs().persist();
        }
    }
}

