/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.QueryStats;
import io.airbrake.javabrake.QueryTimerTask;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queries {
    String environment;
    List<Object> queries;
    static transient String status = null;

    Queries(String environment, List<Object> queries) {
        this.environment = environment;
        this.queries = queries;
    }

    public Queries() {
    }

    public void notify(@NotNull String method, @NotNull String route, @NotNull String query, @NotNull Date startTime, @NotNull Date endTime, @NotNull String function, @NotNull String file, @NotNull int line) {
        status = null;
        if (!Notifier.config.performanceStats) {
            status = "performanceStats is disabled";
            return;
        }
        if (!Notifier.config.queryStats) {
            status = "queryStats is disabled";
            return;
        }
        if (Notifier.config.environment == null || Notifier.config.environment.equals("")) {
            Notifier.config.environment = "production";
        }
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(startTime);
        QueryStats queryStats = new QueryStats(method, route, query, date, function, file, line);
        Notifier.queryList.add(queryStats);
        long ms = endTime.getTime() - startTime.getTime();
        queryStats.add(ms);
        QueryTimerTask.start();
    }

    public void notify(@NotNull String method, @NotNull String route, @NotNull String query, @NotNull Date startTime, @NotNull Date endTime) {
        status = null;
        if (!Notifier.config.performanceStats) {
            status = "performanceStats is disabled";
            return;
        }
        if (!Notifier.config.queryStats) {
            status = "queryStats is disabled";
            return;
        }
        if (Notifier.config.environment == null || Notifier.config.environment.equals("")) {
            Notifier.config.environment = "production";
        }
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(startTime);
        QueryStats queryStats = new QueryStats(method, route, query, date);
        Notifier.queryList.add(queryStats);
        long ms = endTime.getTime() - startTime.getTime();
        queryStats.add(ms);
        queryStats.tdigest = queryStats.getData();
        QueryTimerTask.start();
    }
}

