/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.definition;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.definition.FieldSpecialCharsDefinitionBuilder;
import com.cronutils.utils.Preconditions;

public class FieldDayOfWeekDefinitionBuilder
extends FieldSpecialCharsDefinitionBuilder {
    private int mondayDoWValue = 1;

    public FieldDayOfWeekDefinitionBuilder(CronDefinitionBuilder cronDefinitionBuilder, CronFieldName fieldName) {
        super(cronDefinitionBuilder, fieldName);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)fieldName), "CronFieldName must be DAY_OF_WEEK");
    }

    public FieldDayOfWeekDefinitionBuilder withMondayDoWValue(int mondayDoW) {
        this.constraints.withShiftedStringMapping(mondayDoW - this.mondayDoWValue);
        this.mondayDoWValue = mondayDoW;
        return this;
    }

    @Override
    public CronDefinitionBuilder and() {
        boolean zeroInRange = this.constraints.createConstraintsInstance().isInRange(0);
        this.cronDefinitionBuilder.register(new DayOfWeekFieldDefinition(this.fieldName, this.constraints.createConstraintsInstance(), this.optional, new WeekDay(this.mondayDoWValue, zeroInRange)));
        return this.cronDefinitionBuilder;
    }

    @Override
    public FieldDayOfWeekDefinitionBuilder withValidRange(int startRange, int endRange) {
        super.withValidRange(startRange, endRange);
        return this;
    }

    @Override
    public FieldDayOfWeekDefinitionBuilder withIntMapping(int source2, int dest) {
        super.withIntMapping(source2, dest);
        return this;
    }
}

