/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugUserAgent
extends UserAgent.MutableUserAgent {
    private static final Logger LOG = LogManager.getLogger(DebugUserAgent.class);
    private final transient List<Pair<UserAgent, Matcher>> appliedMatcherResults = new ArrayList<Pair<UserAgent, Matcher>>(32);

    DebugUserAgent(Collection<String> wantedFieldNames) {
        super(wantedFieldNames);
    }

    @Override
    public void set(UserAgent.MutableUserAgent newValuesUserAgent, Matcher appliedMatcher) {
        this.appliedMatcherResults.add(new ImmutablePair<UserAgent.ImmutableUserAgent, Matcher>(new UserAgent.ImmutableUserAgent(newValuesUserAgent), appliedMatcher));
        super.set(newValuesUserAgent, appliedMatcher);
    }

    @Override
    public void reset() {
        this.appliedMatcherResults.clear();
        super.reset();
    }

    int getNumberOfAppliedMatches() {
        return this.appliedMatcherResults.size();
    }

    String toMatchTrace(List<String> highlightNames) {
        StringBuilder sb = new StringBuilder(4096);
        sb.append('\n');
        sb.append("+=========================================+\n");
        sb.append("| Matcher results that have been combined |\n");
        sb.append("+=========================================+\n");
        sb.append('\n');
        this.appliedMatcherResults.sort((o1, o2) -> {
            Matcher m1 = (Matcher)o1.getValue();
            Matcher m22 = (Matcher)o2.getValue();
            return m1.getMatcherSourceLocation().compareTo(m22.getMatcherSourceLocation());
        });
        for (Pair<UserAgent, Matcher> pair : this.appliedMatcherResults) {
            sb.append('\n');
            sb.append("+================\n");
            sb.append("+ Applied matcher\n");
            sb.append("+----------------\n");
            UserAgent result = pair.getLeft();
            Matcher matcher = pair.getRight();
            sb.append(matcher.toString());
            sb.append("+----------------\n");
            sb.append("+ Results\n");
            sb.append("+----------------\n");
            for (String fieldName : result.getAvailableFieldNamesSorted()) {
                AgentField field = result.get(fieldName);
                if (field.getConfidence() < 0L) continue;
                String marker = "";
                if (highlightNames.contains(fieldName)) {
                    marker = " <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<";
                }
                sb.append("| ").append(fieldName).append('(').append(field.getConfidence());
                if (field.isDefaultValue()) {
                    sb.append(" => isDefaultValue");
                }
                sb.append(") = ").append(field.getValue()).append(marker).append('\n');
            }
            sb.append("+================\n");
        }
        return sb.toString();
    }

    boolean analyzeMatchersResult() {
        boolean passed = true;
        for (String fieldName : this.getAvailableFieldNamesSorted()) {
            HashMap<Long, String> receivedValues = new HashMap<Long, String>(32);
            for (Pair<UserAgent, Matcher> pair : this.appliedMatcherResults) {
                UserAgent result = pair.getLeft();
                AgentField partialField = result.get(fieldName);
                if (partialField == null || partialField.getConfidence() <= 0L) continue;
                String previousValue = (String)receivedValues.get(partialField.getConfidence());
                if (previousValue != null) {
                    if (previousValue.equals(partialField.getValue())) continue;
                    if (passed) {
                        LOG.error("***********************************************************");
                        LOG.error("***        REALLY IMPORTANT ERRORS IN THE RULESET       ***");
                        LOG.error("*** YOU MUST CHANGE THE CONFIDENCE LEVELS OF YOUR RULES ***");
                        LOG.error("***********************************************************");
                    }
                    passed = false;
                    LOG.error("Found different value for \"{}\" with SAME confidence {}: \"{}\" and \"{}\"", (Object)fieldName, (Object)partialField.getConfidence(), (Object)previousValue, (Object)partialField.getValue());
                    continue;
                }
                receivedValues.put(partialField.getConfidence(), partialField.getValue());
            }
        }
        return passed;
    }
}

