/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatchMaker;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherExtractAction;
import nl.basjes.parse.useragent.analyze.MatcherFailIfFoundAction;
import nl.basjes.parse.useragent.analyze.MatcherRequireAction;
import nl.basjes.parse.useragent.analyze.MatcherVariableAction;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.config.MatcherConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Matcher
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(Matcher.class);
    private final MatchMaker analyzer;
    private final List<MatcherVariableAction> variableActions;
    private final List<MatcherAction> dynamicActions;
    private final List<MatcherAction> fixedStringActions;
    private UserAgent.MutableUserAgent newValuesUserAgent = null;
    private long actionsThatRequireInput;
    private boolean verbose;
    private boolean permanentVerbose;
    private String sourceFileName;
    private Integer sourceFileLineNumber;
    private String matcherSourceLocation;
    private final Map<String, Set<MatcherAction>> informMatcherActionsAboutVariables = new HashMap<String, Set<MatcherAction>>(8);
    private boolean alreadyNotifiedAnalyzerWeReceivedInput = false;
    private long actionsThatRequireInputAndReceivedInput = 0L;

    public String getMatcherSourceLocation() {
        return this.matcherSourceLocation;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public Integer getSourceFileLineNumber() {
        return this.sourceFileLineNumber;
    }

    private Matcher() {
        this.analyzer = null;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    Matcher(MatchMaker analyzer) {
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    public void destroy() {
        this.dynamicActions.forEach(MatcherAction::destroy);
        this.dynamicActions.clear();
        this.fixedStringActions.forEach(MatcherAction::destroy);
        this.fixedStringActions.clear();
    }

    public Map<String, Map<String, String>> getLookups() {
        return this.analyzer.getLookups();
    }

    public Map<String, Set<String>> getLookupSets() {
        return this.analyzer.getLookupSets();
    }

    public Matcher(MatchMaker analyzer, Collection<String> wantedFieldNames, MatcherConfig matcherConfig) throws UselessMatcherException {
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
        this.newValuesUserAgent = new UserAgent.MutableUserAgent(wantedFieldNames);
        this.sourceFileName = matcherConfig.getMatcherSourceFilename();
        this.sourceFileLineNumber = matcherConfig.getMatcherSourceLineNumber();
        this.matcherSourceLocation = this.sourceFileName + ':' + this.sourceFileLineNumber;
        this.verbose = false;
        List<String> options = matcherConfig.getOptions();
        if (options != null && options.contains("verbose")) {
            this.verbose = true;
            this.permanentVerbose = true;
        }
        boolean hasActiveExtractConfigs = false;
        boolean hasDefinedExtractConfigs = false;
        if (this.verbose) {
            LOG.info("---------------------------");
            LOG.info("- MATCHER -");
        }
        for (MatcherConfig.ConfigLine configLine : matcherConfig.getConfigLines()) {
            if (this.verbose) {
                LOG.info("{}: {}", (Object)configLine.getType(), (Object)configLine.getExpression());
            }
            switch (configLine.getType()) {
                case VARIABLE: {
                    this.variableActions.add(new MatcherVariableAction(configLine.getAttribute(), configLine.getExpression(), this));
                    break;
                }
                case REQUIRE: {
                    this.dynamicActions.add(new MatcherRequireAction(configLine.getExpression(), this));
                    break;
                }
                case FAIL_IF_FOUND: {
                    this.dynamicActions.add(new MatcherFailIfFoundAction(configLine.getExpression(), this));
                    break;
                }
                case EXTRACT: {
                    hasDefinedExtractConfigs = true;
                    if (wantedFieldNames == null || wantedFieldNames.contains(configLine.getAttribute())) {
                        MatcherExtractAction action = new MatcherExtractAction(configLine.getAttribute(), configLine.getConfidence(), configLine.getExpression(), this);
                        this.dynamicActions.add(action);
                        this.newValuesUserAgent.set(configLine.getAttribute(), "Dummy", -9999L);
                        action.setResultAgentField(this.newValuesUserAgent.get(configLine.getAttribute()));
                        hasActiveExtractConfigs = true;
                        break;
                    }
                    this.dynamicActions.add(new MatcherDemotedExtractAction(configLine.getExpression(), this));
                    break;
                }
            }
        }
        if (!hasDefinedExtractConfigs) {
            throw new InvalidParserConfigurationException("Matcher does not extract anything:" + this.matcherSourceLocation);
        }
        if (!hasActiveExtractConfigs) {
            throw new UselessMatcherException("Does not extract any wanted fields" + this.matcherSourceLocation);
        }
    }

    public void initialize() {
        long newEntries = 0L;
        long initStart = System.nanoTime();
        try {
            for (MatcherVariableAction matcherVariableAction : this.variableActions) {
                newEntries += matcherVariableAction.initialize();
            }
        }
        catch (InvalidParserConfigurationException e) {
            throw new InvalidParserConfigurationException("Syntax error.(" + this.matcherSourceLocation + ")", e);
        }
        HashSet<MatcherAction> uselessRequireActions = new HashSet<MatcherAction>();
        for (MatcherAction matcherAction : this.dynamicActions) {
            try {
                newEntries += matcherAction.initialize();
            }
            catch (InvalidParserConfigurationException e) {
                if (!(matcherAction instanceof MatcherDemotedExtractAction) || !e.getMessage().startsWith("It is useless to put a fixed value")) {
                    throw new InvalidParserConfigurationException("Syntax error.(" + this.matcherSourceLocation + ")" + e.getMessage(), e);
                }
                uselessRequireActions.add(matcherAction);
            }
        }
        for (MatcherAction matcherAction : this.dynamicActions) {
            if (!(matcherAction instanceof MatcherExtractAction) || !((MatcherExtractAction)matcherAction).isFixedValue()) continue;
            this.fixedStringActions.add(matcherAction);
            matcherAction.obtainResult();
        }
        this.fixedStringActions.forEach(this.dynamicActions::remove);
        uselessRequireActions.forEach(this.dynamicActions::remove);
        HashSet<MatcherVariableAction> hashSet = new HashSet<MatcherVariableAction>(this.variableActions.size());
        for (MatcherVariableAction variableAction : this.variableActions) {
            hashSet.add(variableAction);
            Set<MatcherAction> interestedActions = this.informMatcherActionsAboutVariables.get(variableAction.getVariableName());
            if (interestedActions == null || interestedActions.isEmpty()) continue;
            variableAction.setInterestedActions(interestedActions);
            for (MatcherAction interestedAction : interestedActions) {
                if (!hashSet.contains(interestedAction)) continue;
                throw new InvalidParserConfigurationException("Syntax error (" + this.matcherSourceLocation + "): The line >>" + interestedAction + "<< is referencing variable @" + variableAction.getVariableName() + " which is not defined yet.");
            }
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet seenVariableNames = new HashSet();
        hashSet.forEach(m3 -> seenVariableNames.add(((MatcherVariableAction)m3).getVariableName()));
        for (String variableName : this.informMatcherActionsAboutVariables.keySet()) {
            if (seenVariableNames.contains(variableName)) continue;
            hashSet2.add(variableName);
        }
        if (!hashSet2.isEmpty()) {
            throw new InvalidParserConfigurationException("Syntax error (" + this.matcherSourceLocation + "): Used, yet undefined variables: " + hashSet2);
        }
        this.dynamicActions.addAll(0, this.variableActions);
        this.actionsThatRequireInput = this.countActionsThatMustHaveMatches(this.dynamicActions);
        long initFinish = System.nanoTime();
        if (newEntries > 3000L) {
            LOG.warn("Large matcher: {} in {} ms:.({})", (Object)newEntries, (Object)((initFinish - initStart) / 1000000L), (Object)this.matcherSourceLocation);
        }
        if (this.verbose) {
            LOG.info("---------------------------");
        }
    }

    private long countActionsThatMustHaveMatches(List<? extends MatcherAction> actions) {
        long actionsThatMustHaveMatches = 0L;
        for (MatcherAction matcherAction : actions) {
            matcherAction.reset();
            if (!matcherAction.mustHaveMatches()) continue;
            ++actionsThatMustHaveMatches;
        }
        return actionsThatMustHaveMatches;
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(this.getAllPossibleFieldNames(this.dynamicActions));
        results.addAll(this.getAllPossibleFieldNames(this.fixedStringActions));
        results.remove("__Set_ALL_Fields__");
        return results;
    }

    private Set<String> getAllPossibleFieldNames(List<MatcherAction> actions) {
        TreeSet<String> results = new TreeSet<String>();
        for (MatcherAction action : actions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            MatcherExtractAction extractAction = (MatcherExtractAction)action;
            results.add(extractAction.getAttribute());
        }
        return results;
    }

    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        this.analyzer.lookingForRange(treeName, range);
    }

    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        this.analyzer.informMeAbout(matcherAction, keyPattern);
    }

    public void informMeAboutPrefix(MatcherAction matcherAction, String keyPattern, String prefix) {
        this.analyzer.informMeAboutPrefix(matcherAction, keyPattern, prefix);
    }

    void informMeAboutVariable(MatcherAction matcherAction, String variableName) {
        Set analyzerSet = this.informMatcherActionsAboutVariables.computeIfAbsent(variableName, k -> new LinkedHashSet());
        analyzerSet.add(matcherAction);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void analyze(UserAgent.MutableUserAgent userAgent) {
        if (this.verbose) {
            LOG.info("");
            LOG.info("--- Matcher.({}) ------------------------", (Object)this.matcherSourceLocation);
            LOG.info("ANALYSE ----------------------------");
            boolean good = true;
            for (MatcherAction action : this.dynamicActions) {
                if (!action.cannotBeValid()) continue;
                LOG.error("CANNOT BE VALID : {}", (Object)action.getMatchExpression());
                good = false;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            if (!good) {
                LOG.info("INCOMPLETE ----------------------------");
                return;
            }
            LOG.info("COMPLETE ----------------------------");
        } else {
            if (this.actionsThatRequireInput != this.actionsThatRequireInputAndReceivedInput) {
                return;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                return;
            }
        }
        userAgent.set(this.newValuesUserAgent, this);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    void receivedInput() {
        if (this.alreadyNotifiedAnalyzerWeReceivedInput) {
            return;
        }
        this.analyzer.receivedInput(this);
        this.alreadyNotifiedAnalyzerWeReceivedInput = true;
    }

    public long getActionsThatRequireInput() {
        return this.actionsThatRequireInput;
    }

    public long getActionsThatRequireInputAndReceivedInput() {
        return this.actionsThatRequireInputAndReceivedInput;
    }

    void gotMyFirstStartingPoint() {
        ++this.actionsThatRequireInputAndReceivedInput;
    }

    protected void failImmediately() {
        this.actionsThatRequireInputAndReceivedInput = Long.MIN_VALUE;
    }

    public void setVerboseTemporarily(boolean newVerbose) {
        for (MatcherAction action : this.dynamicActions) {
            action.setVerbose(newVerbose, true);
        }
    }

    public void reset() {
        this.alreadyNotifiedAnalyzerWeReceivedInput = false;
        this.actionsThatRequireInputAndReceivedInput = 0L;
        this.verbose = this.permanentVerbose;
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
        }
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public List<MatchesList.Match> getUsedMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            if (!action.cannotBeValid()) continue;
            return new ArrayList<MatchesList.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (!action.obtainResult()) {
                return new ArrayList<MatchesList.Match>();
            }
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("MATCHER.(").append(this.matcherSourceLocation).append("):\n").append("    VARIABLE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherVariableAction)) continue;
            sb.append("        @").append(((MatcherVariableAction)action).getVariableName()).append(":    ").append(action.getMatchExpression()).append('\n');
            sb.append("        -->").append(action.getMatches().toStrings()).append('\n');
        }
        sb.append("    REQUIRE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherRequireAction)) continue;
            sb.append("        ").append(action.getMatchExpression()).append('\n');
            if (action.getMatches() == null) continue;
            sb.append("        -->").append(action.getMatches().toStrings()).append('\n');
        }
        sb.append("    FAIL_IF_FOUND:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherFailIfFoundAction)) continue;
            sb.append("        ").append(action.getMatchExpression()).append('\n');
            if (action.getMatches() == null) continue;
            sb.append("        -->").append(action.getMatches().toStrings()).append('\n');
        }
        sb.append("    EXTRACT:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            sb.append("        ").append(action).append('\n');
            if (action.getMatches() == null) continue;
            sb.append("        -->").append(action.getMatches()).append('\n');
        }
        for (MatcherAction action : this.fixedStringActions) {
            sb.append("        ").append(action).append('\n');
        }
        return sb.toString();
    }

    public static class MatcherDemotedExtractAction
    extends MatcherRequireAction {
        private MatcherDemotedExtractAction() {
        }

        MatcherDemotedExtractAction(String config, Matcher matcher) {
            super(config, matcher);
        }
    }
}

