/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public final class AnalyzerUtilities {
    private AnalyzerUtilities() {
    }

    @Nonnull
    public static ParsedArguments parseArguments(@Nonnull String[] args2, @Nonnull List<String> allAllowedFields, @Nonnull List<String> allAllowedHeaders) {
        ArrayList<String> input = new ArrayList<String>(Arrays.asList(args2));
        return AnalyzerUtilities.parseArguments(input, allAllowedFields, allAllowedHeaders);
    }

    @Nonnull
    public static ParsedArguments parseArguments(@Nonnull List<String> args2, @Nonnull List<String> allAllowedFields, @Nonnull List<String> allAllowedHeaders) {
        ParsedArguments parsedArguments = new ParsedArguments();
        int i = 0;
        while (i < args2.size()) {
            String argument = args2.get(i);
            if (argument == null) {
                if (i == 0) {
                    parsedArguments.requestHeaders.put("User-Agent", null);
                    ++i;
                    continue;
                }
                int locationOfFirstNull = i;
                while (i < args2.size()) {
                    if (args2.get(i) != null) {
                        throw new IllegalArgumentException("Null argument provided to ParseUserAgent (Argument #" + locationOfFirstNull + " [0=first]).");
                    }
                    ++i;
                }
                return parsedArguments;
            }
            if (allAllowedFields.stream().anyMatch(argument::equalsIgnoreCase)) {
                parsedArguments.wantedFields.add(argument);
                ++i;
                continue;
            }
            if (allAllowedHeaders.stream().anyMatch(argument::equalsIgnoreCase)) {
                if (i + 1 >= args2.size()) {
                    throw new IllegalArgumentException("Invalid last element in argument list (was a header name which requires a value to follow)");
                }
                String value = args2.get(i + 1);
                ++i;
                parsedArguments.requestHeaders.put(argument, value);
                ++i;
                continue;
            }
            if (i == 0) {
                parsedArguments.requestHeaders.put("User-Agent", argument);
                ++i;
                continue;
            }
            if (argument.isEmpty()) {
                throw new IllegalArgumentException("Empty argument provided to ParseUserAgent (Argument #" + i + " [0=first]).");
            }
            throw new IllegalArgumentException("Unknown argument provided to ParseUserAgent (Argument #" + i + " [0=first]).");
        }
        return parsedArguments;
    }

    public static class ParsedArguments {
        private Map<String, String> requestHeaders = new TreeMap<String, String>();
        private List<String> wantedFields = new ArrayList<String>();

        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public void setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        public List<String> getWantedFields() {
            return this.wantedFields;
        }

        public void setWantedFields(List<String> wantedFields) {
            this.wantedFields = wantedFields;
        }
    }
}

