/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.service;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.dartnode.mon.entites.service.HiveService;
import net.dartnode.mon.entites.task.CronTask;
import net.dartnode.mon.entites.task.HiveTask;
import net.dartnode.mon.entites.task.RunLater;
import net.dartnode.mon.entites.task.ScheduleTask;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Singleton
public class TaskService
implements HiveService<TaskService> {
    private ScheduledExecutorService timer = Executors.newScheduledThreadPool(6);
    private ConcurrentHashMap<String, ScheduledFuture> futures = new ConcurrentHashMap();

    public void runLater(HiveTask runnable2, long delay) {
        System.out.println("Scheduled a Run Later Task (" + runnable2.getFriendlyName() + ")");
        ScheduledFuture<?> f = this.timer.schedule(runnable2, delay, TimeUnit.MILLISECONDS);
        this.futures.put(runnable2.getFriendlyName(), f);
    }

    public void scheduleRepeatingTask(HiveTask task, long delay, long timeBetween) {
        System.out.println("Scheduling Repeating Task (" + task.getFriendlyName() + " period)");
        ScheduledFuture<?> f = this.timer.scheduleAtFixedRate(task, delay, timeBetween, TimeUnit.MILLISECONDS);
        this.futures.put(task.getFriendlyName(), f);
    }

    @Override
    public void init() {
        this.loadTasks();
    }

    public void cancelByName(String firnedlyName) {
        if (this.futures.containsKey(firnedlyName)) {
            this.futures.get(firnedlyName).cancel(true);
            this.futures.remove(firnedlyName);
        }
    }

    public void loadTasks() {
        HiveTask task;
        Annotation ann;
        Set<Class<?>> runLater = new Reflections("net.dartnode", new Scanner[0]).getTypesAnnotatedWith(RunLater.class);
        Set<Class<?>> scheduleTask = new Reflections("net.dartnode", new Scanner[0]).getTypesAnnotatedWith(ScheduleTask.class);
        Set<Class<?>> cronTasks = new Reflections("net.dartnode", new Scanner[0]).getTypesAnnotatedWith(CronTask.class);
        int runLaterC = 0;
        int scheduleC = 0;
        for (Class<?> c : runLater) {
            try {
                ann = c.getAnnotation(RunLater.class);
                task = (HiveTask)c.newInstance();
                task.setFriendlyName(ann.name());
                this.runLater(task, ann.delay());
                ++runLaterC;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        for (Class<?> c : scheduleTask) {
            try {
                ann = c.getAnnotation(ScheduleTask.class);
                task = (HiveTask)c.newInstance();
                task.setFriendlyName(ann.name());
                this.scheduleRepeatingTask(task, ann.delay(), ann.period());
                ++scheduleC;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        for (Class<?> c : cronTasks) {
            try {
                ann = c.getAnnotation(CronTask.class);
                task = (HiveTask)c.newInstance();
                CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX);
                CronParser parser = new CronParser(definition);
                final Cron cron = parser.parse(ann.cronExpression());
                ZonedDateTime now = ZonedDateTime.now().toLocalDateTime().atZone(ZoneId.of("UTC"));
                ExecutionTime execTime = ExecutionTime.forCron(cron);
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        task.run();
                        ZonedDateTime now = ZonedDateTime.now().toLocalDateTime().atZone(ZoneId.of("UTC"));
                        ExecutionTime execTime = ExecutionTime.forCron(cron);
                        long diff = System.currentTimeMillis() - execTime.nextExecution(now).get().toEpochSecond() * 1000L;
                        TaskService.this.timer.schedule(this, diff, TimeUnit.MILLISECONDS);
                    }
                }, System.currentTimeMillis() - execTime.nextExecution(now).get().toEpochSecond() * 1000L, TimeUnit.SECONDS);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\tRun Later Tasks Imported: " + runLaterC);
        System.out.println("\tScheduled Repeating Tasks Imported: " + scheduleC);
    }
}

