/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.service;

import java.util.Hashtable;
import java.util.Set;
import javax.inject.Singleton;
import net.dartnode.mon.entites.command.Command;
import net.dartnode.mon.entites.command.HiveCommand;
import net.dartnode.mon.entites.command.HiveCommandPromise;
import net.dartnode.mon.entites.command.HiveConsoleCommand;
import net.dartnode.mon.entites.net.HiveReplyMessage;
import net.dartnode.mon.entites.service.HiveService;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Singleton
public class CommandService
implements HiveService<CommandService> {
    private Hashtable<String, HiveConsoleCommand> consoleCommands = new Hashtable();
    private Hashtable<String, HiveCommand> netCommands = new Hashtable();
    private Hashtable<String, HiveCommandPromise> awaitingReply = new Hashtable();

    @Override
    public void init() {
        System.out.println("\tLoading Commands...");
        Set<Class<HiveConsoleCommand>> commandClasses = new Reflections("net.dartnode", new Scanner[0]).getSubTypesOf(HiveConsoleCommand.class);
        Set<Class<HiveCommand>> newCommandClasses = new Reflections("net.dartnode", new Scanner[0]).getSubTypesOf(HiveCommand.class);
        System.out.println("\t\tFound " + commandClasses.size() + " console commands to load.");
        System.out.println("\t\tFound " + newCommandClasses.size() + " net commands to load.");
        this.loadCommands(HiveConsoleCommand.class, commandClasses);
        this.loadCommands(HiveCommand.class, newCommandClasses);
    }

    private <T> void loadCommands(T t, Set<T> commandClasses) {
        for (T cc2 : commandClasses) {
            Class cc = (Class)cc2;
            Command hc = cc.getAnnotation(Command.class);
            if (hc != null) {
                try {
                    Object c;
                    if (HiveConsoleCommand.class.isAssignableFrom(cc)) {
                        c = (HiveConsoleCommand)cc.newInstance();
                        ((HiveConsoleCommand)c).name = hc.name();
                        this.consoleCommands.put(((HiveConsoleCommand)c).name, (HiveConsoleCommand)c);
                        for (String sub : hc.aliases().split(",")) {
                            this.consoleCommands.put(sub, (HiveConsoleCommand)c);
                        }
                        System.out.println("\t\t\tLoaded CLI CMD " + ((HiveConsoleCommand)c).name + ".");
                        continue;
                    }
                    if (!HiveCommand.class.isAssignableFrom(cc)) continue;
                    c = (HiveCommand)cc.newInstance();
                    ((HiveCommand)c).name = hc.name();
                    ((HiveCommand)c).allowedSource = hc.netSource();
                    this.netCommands.put(((HiveCommand)c).name, (HiveCommand)c);
                    for (String sub : hc.aliases().split(",")) {
                        this.netCommands.put(sub, (HiveCommand)c);
                    }
                    System.out.println("\t\t\tLoaded as NET CMD " + ((HiveCommand)c).name + ".");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.err.println("HC is null");
        }
    }

    public void triggerReplyHooks(HiveReplyMessage replyMessage) {
        if (this.awaitingReply.containsKey(replyMessage.id)) {
            HiveCommandPromise promise = this.awaitingReply.get(replyMessage.id);
            promise.setReplyMessage(replyMessage);
            promise.run();
            this.awaitingReply.remove(replyMessage.id);
        }
    }

    public HiveConsoleCommand findConsoleCommand(String name) {
        if (this.consoleCommands.containsKey(name)) {
            return this.consoleCommands.get(name);
        }
        return null;
    }

    public HiveCommand findNetCommand(String name) {
        if (this.netCommands.containsKey(name)) {
            return this.netCommands.get(name);
        }
        return null;
    }
}

