/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.util.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UUID;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.entites.util.cli.CliPromise;
import net.dartnode.mon.service.ThreadService;

public class CliTask {
    public UUID uuid = UUID.randomUUID();
    public String toRun;
    public StringBuilder reply;
    public Exception exception;
    public boolean isRunning = false;
    public CliPromise onComplete;
    public CliPromise onLine;
    private String lastLine = "";

    public CliTask(String toRun) {
        this.toRun = toRun;
        this.reply = new StringBuilder();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getToRun() {
        return this.toRun;
    }

    public StringBuilder getReply() {
        return this.reply;
    }

    public CliTask onComplete(CliPromise promise) {
        this.onComplete = promise;
        return this;
    }

    public CliTask onLineRead(CliPromise promise) {
        this.onLine = promise;
        return this;
    }

    public String getLastLine() {
        return this.lastLine;
    }

    public boolean run() throws IOException {
        System.out.println("CLI Task Queued: " + this.getUuid().toString());
        DartNodeCore.get(ThreadService.class).queueToPool(() -> {
            this.isRunning = true;
            System.out.println("Runnng CLI Task: " + this.getUuid().toString());
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command("sh", "-c", this.toRun);
                pb.directory(new File("/usr/local/nebula"));
                Process p = pb.start();
                p.waitFor();
                int exitValue = p.exitValue();
                System.out.println("CLI EXIT VALUE = " + exitValue);
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = in.readLine()) != null) {
                    this.reply.append(line);
                }
                System.out.println("--- CLI TASK " + this.getUuid().toString() + " RETURN ---");
                System.out.println(this.reply.toString());
                System.out.println("--- [END RETURN] ---");
                if (this.onComplete != null) {
                    this.onComplete.setTask(this);
                    this.onComplete.run();
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
            this.isRunning = false;
            System.out.println("Completed CLI Task: " + this.getUuid().toString());
        });
        return true;
    }
}

