/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.entites.events.Event;
import net.dartnode.mon.entites.events.EventHandler;
import net.dartnode.mon.entites.events.EventHook;
import net.dartnode.mon.entites.events.EventInterface;
import net.dartnode.mon.entites.events.EventPriority;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Singleton
public class EventManager {
    private ConcurrentHashMap<Class, LinkedList<EventHook>> hooks = new ConcurrentHashMap();

    public EventManager() {
        this.loadEvents();
    }

    public void register(Event event) {
        System.out.println("\tRegistered Event: " + event.getClass().getSimpleName());
        this.hooks.put(event.getClass(), new LinkedList());
    }

    public void loadEvents() {
        System.out.println("\t Scanning for Event Hooks...");
        try {
            Set<Class<EventInterface>> eventHandlers = new Reflections("net.dartnode", new Scanner[0]).getSubTypesOf(EventInterface.class);
            for (final Class<EventInterface> c : eventHandlers) {
                System.out.println("\t\tInterface " + c.getSimpleName());
                for (final Method m3 : c.getMethods()) {
                    m3.setAccessible(true);
                    if (m3.getAnnotation(EventHandler.class) == null) continue;
                    final EventHandler annon = m3.getAnnotation(EventHandler.class);
                    for (Parameter p : m3.getParameters()) {
                        Class<?> hookTo = p.getType();
                        System.out.println("\t\t\tFound Hook " + m3.getName() + " to " + hookTo.getSimpleName() + " event.");
                        if (!this.hooks.containsKey(hookTo)) {
                            this.hooks.put(hookTo, new LinkedList());
                        }
                        if (!this.hooks.containsKey(hookTo)) continue;
                        EventHook hook = new EventHook(){

                            @Override
                            public EventPriority getPriority() {
                                return annon.priority();
                            }

                            public void run(Event event) {
                                EventInterface eventInterface = (EventInterface)DartNodeCore.get(c);
                                m3.setAccessible(true);
                                try {
                                    m3.invoke((Object)eventInterface, event);
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        this.hooks.get(hookTo).add(hook);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to hook to events, possibly no hooks setup... skipping.");
        }
    }

    public ConcurrentHashMap<Class, LinkedList<EventHook>> getHooks() {
        return this.hooks;
    }
}

