/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkUtils {
    public static String getCIDRBlock(String ip, int prefixLength) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(ip);
        byte[] addressBytes = inetAddress.getAddress();
        int mask = -1 << 32 - prefixLength;
        int ipAsInt = 0;
        for (byte b : addressBytes) {
            ipAsInt = ipAsInt << 8 | b & 0xFF;
        }
        int networkAddress = ipAsInt & mask;
        byte[] networkAddressBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            networkAddressBytes[i] = (byte)(networkAddress >> (3 - i) * 8 & 0xFF);
        }
        InetAddress networkInetAddress = InetAddress.getByAddress(networkAddressBytes);
        return networkInetAddress.getHostAddress() + "/" + prefixLength;
    }
}

