/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.IPMonitor;
import net.dartnode.mon.entites.task.HiveTask;
import net.dartnode.mon.service.RedisService;
import net.dartnode.mon.service.TaskService;
import net.dartnode.mon.service.ThreadService;
import net.dartnode.mon.sflow.SFlowCollector;

public class Main {
    public static DartNodeCore dn;
    public static boolean inProgress;

    public static void main(String[] args2) {
        dn = new DartNodeCore(null);
        System.out.println("Starting IP Monitor Task...");
        DartNodeCore.get(TaskService.class).scheduleRepeatingTask(new HiveTask(){

            @Override
            public void run() {
                Map filtering = DartNodeCore.get(RedisService.class).getRedisConnection().sync().hgetall("ddos_filter");
                for (String ip : filtering.keySet()) {
                    IPMonitor.monitorInboundIPs(ip);
                }
            }
        }, 1000L, 1000L);
        DartNodeCore.get(ThreadService.class).runDedicatedThread("sflow", () -> {
            System.out.println("Starting netFlow Service...");
            SFlowCollector.start();
        });
        DartNodeCore.get(TaskService.class).scheduleRepeatingTask(new HiveTask(){

            @Override
            public void run() {
                SFlowCollector.detectHighPPS();
            }
        }, TimeUnit.MINUTES.toMillis(1L), TimeUnit.MINUTES.toMillis(1L));
    }

    static {
        inProgress = false;
    }
}

