/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import io.lettuce.core.tracing.NoOpTracing;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.TracerProvider;
import java.net.SocketAddress;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public interface Tracing {
    public TracerProvider getTracerProvider();

    public TraceContextProvider initialTraceContextProvider();

    public boolean isEnabled();

    public boolean includeCommandArgsInSpanTags();

    public Endpoint createEndpoint(SocketAddress var1);

    public static Tracing disabled() {
        return NoOpTracing.INSTANCE;
    }

    public static Mono<TraceContextProvider> getContext() {
        return Mono.subscriberContext().filter(c -> c.hasKey(TraceContextProvider.class)).map(c -> c.get(TraceContextProvider.class));
    }

    public static Function<Context, Context> clearContext() {
        return context -> context.delete(TraceContextProvider.class);
    }

    public static Context withTraceContextProvider(TraceContextProvider supplier) {
        return Context.of(TraceContextProvider.class, supplier);
    }

    public static interface Endpoint {
    }
}

