/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.event;

import io.lettuce.core.event.Event;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.jfr.EventRecorder;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;

public class DefaultEventBus
implements EventBus {
    private final DirectProcessor<Event> bus;
    private final FluxSink<Event> sink;
    private final Scheduler scheduler;
    private final EventRecorder recorder = EventRecorder.getInstance();

    public DefaultEventBus(Scheduler scheduler) {
        this.bus = DirectProcessor.create();
        this.sink = this.bus.sink();
        this.scheduler = scheduler;
    }

    @Override
    public Flux<Event> get() {
        return this.bus.onBackpressureDrop().publishOn(this.scheduler);
    }

    @Override
    public void publish(Event event) {
        this.recorder.record(event);
        this.sink.next(event);
    }
}

