/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.QueueMetric;
import io.airbrake.javabrake.QueueStats;
import io.airbrake.javabrake.QueueTimerTask;
import java.text.SimpleDateFormat;
import java.util.List;

public class Queues {
    String environment;
    List<Object> queues;
    static transient String status = null;

    Queues(String environment, List<Object> queues) {
        this.environment = environment;
        this.queues = queues;
    }

    Queues() {
    }

    public void notify(QueueMetric metrics) {
        status = null;
        if (!Notifier.config.performanceStats) {
            status = "performanceStats is disabled";
            return;
        }
        if (!Notifier.config.queueStats) {
            status = "queueStats is disabled";
            return;
        }
        if (Notifier.config.environment == null || Notifier.config.environment.equals("")) {
            Notifier.config.environment = "production";
        }
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(metrics.startTime);
        QueueStats queueStats = new QueueStats(metrics.queue, date);
        Notifier.queueList.add(queueStats);
        long ms = metrics.endTime.getTime() - metrics.startTime.getTime();
        queueStats.addGroups(ms, metrics.groups);
        QueueTimerTask.start();
    }
}

